/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.AssistedFactoryBinding;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.BoundInstanceBinding;
import dagger.internal.codegen.binding.ComponentBinding;
import dagger.internal.codegen.binding.ComponentDependencyBinding;
import dagger.internal.codegen.binding.ComponentDependencyProductionBinding;
import dagger.internal.codegen.binding.ComponentDependencyProvisionBinding;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.binding.InjectionSiteFactory;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MembersInjectorBinding;
import dagger.internal.codegen.binding.MultiboundMapBinding;
import dagger.internal.codegen.binding.MultiboundSetBinding;
import dagger.internal.codegen.binding.OptionalBinding;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SubcomponentCreatorBinding;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Optional;
import javax.inject.Inject;

public final class BindingFactory {
    private final KeyFactory keyFactory;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final InjectionSiteFactory injectionSiteFactory;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    BindingFactory(KeyFactory keyFactory, DependencyRequestFactory dependencyRequestFactory, InjectionSiteFactory injectionSiteFactory, InjectionAnnotations injectionAnnotations) {
        this.keyFactory = keyFactory;
        this.dependencyRequestFactory = dependencyRequestFactory;
        this.injectionSiteFactory = injectionSiteFactory;
        this.injectionAnnotations = injectionAnnotations;
    }

    public InjectionBinding injectionBinding(XConstructorElement constructorElement, Optional<XType> resolvedEnclosingType) {
        Preconditions.checkArgument((boolean)InjectionAnnotations.hasInjectAnnotation(constructorElement));
        XConstructorType constructorType = constructorElement.getExecutableType();
        XType enclosingType = constructorElement.getEnclosingElement().getType();
        if (!enclosingType.getTypeArguments().isEmpty() && resolvedEnclosingType.isPresent()) {
            this.checkIsSameErasedType(resolvedEnclosingType.get(), enclosingType);
            enclosingType = resolvedEnclosingType.get();
            constructorType = constructorElement.asMemberOf(enclosingType);
        }
        ImmutableSet.Builder constructorDependencies = ImmutableSet.builder();
        for (int i = 0; i < constructorElement.getParameters().size(); ++i) {
            XExecutableParameterElement parameter = constructorElement.getParameters().get(i);
            XType parameterType = constructorType.getParameterTypes().get(i);
            constructorDependencies.add((Object)this.dependencyRequestFactory.forRequiredResolvedVariable(parameter, parameterType));
        }
        return (InjectionBinding)((InjectionBinding.Builder)((InjectionBinding.Builder)((InjectionBinding.Builder)((InjectionBinding.Builder)InjectionBinding.builder().bindingElement(constructorElement)).key(this.keyFactory.forInjectConstructorWithResolvedType(enclosingType))).constructorDependencies((Iterable<DependencyRequest>)constructorDependencies.build()).injectionSites(this.injectionSiteFactory.getInjectionSites(enclosingType)).scope(this.injectionAnnotations.getScope(constructorElement.getEnclosingElement()))).unresolved(BindingFactory.hasNonDefaultTypeParameters(enclosingType) ? Optional.of(this.injectionBinding(constructorElement, Optional.empty())) : Optional.empty())).build();
    }

    public AssistedInjectionBinding assistedInjectionBinding(XConstructorElement constructorElement, Optional<XType> resolvedEnclosingType) {
        Preconditions.checkArgument((boolean)constructorElement.hasAnnotation(XTypeNames.ASSISTED_INJECT));
        XConstructorType constructorType = constructorElement.getExecutableType();
        XType enclosingType = constructorElement.getEnclosingElement().getType();
        if (!enclosingType.getTypeArguments().isEmpty() && resolvedEnclosingType.isPresent()) {
            this.checkIsSameErasedType(resolvedEnclosingType.get(), enclosingType);
            enclosingType = resolvedEnclosingType.get();
            constructorType = constructorElement.asMemberOf(enclosingType);
        }
        ImmutableSet.Builder constructorDependencies = ImmutableSet.builder();
        for (int i = 0; i < constructorElement.getParameters().size(); ++i) {
            XExecutableParameterElement parameter = constructorElement.getParameters().get(i);
            XType parameterType = constructorType.getParameterTypes().get(i);
            if (AssistedInjectionAnnotations.isAssistedParameter(parameter)) continue;
            constructorDependencies.add((Object)this.dependencyRequestFactory.forRequiredResolvedVariable(parameter, parameterType));
        }
        return (AssistedInjectionBinding)((AssistedInjectionBinding.Builder)((AssistedInjectionBinding.Builder)((AssistedInjectionBinding.Builder)((AssistedInjectionBinding.Builder)AssistedInjectionBinding.builder().bindingElement(constructorElement)).key(this.keyFactory.forInjectConstructorWithResolvedType(enclosingType))).constructorDependencies((Iterable<DependencyRequest>)constructorDependencies.build()).injectionSites(this.injectionSiteFactory.getInjectionSites(enclosingType)).scope(this.injectionAnnotations.getScope(constructorElement.getEnclosingElement()))).unresolved(BindingFactory.hasNonDefaultTypeParameters(enclosingType) ? Optional.of(this.assistedInjectionBinding(constructorElement, Optional.empty())) : Optional.empty())).build();
    }

    public AssistedFactoryBinding assistedFactoryBinding(XTypeElement factory, Optional<XType> resolvedFactoryType) {
        XType factoryType = factory.getType();
        if (!factoryType.getTypeArguments().isEmpty() && resolvedFactoryType.isPresent()) {
            this.checkIsSameErasedType(resolvedFactoryType.get(), factoryType);
            factoryType = resolvedFactoryType.get();
        }
        XMethodElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factory);
        XMethodType factoryMethodType = factoryMethod.asMemberOf(factoryType);
        return (AssistedFactoryBinding)((AssistedFactoryBinding.Builder)((AssistedFactoryBinding.Builder)AssistedFactoryBinding.builder().key(this.keyFactory.forType(factoryType))).bindingElement(factory)).assistedInjectKey(this.keyFactory.forType(factoryMethodType.getReturnType())).build();
    }

    public ProvisionBinding providesMethodBinding(XMethodElement method, XTypeElement module) {
        XMethodType methodType = method.asMemberOf(module.getType());
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().scope(this.injectionAnnotations.getScope(method))).nullability(Nullability.of(method)).bindingElement(method)).contributingModule(module)).key(this.keyFactory.forProvidesMethod(method, module))).dependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forRequiredResolvedVariables(method.getParameters(), methodType.getParameterTypes())).unresolved(methodType.isSameType(method.getExecutableType()) ? Optional.empty() : Optional.of(this.providesMethodBinding(method, XElements.asTypeElement(method.getEnclosingElement()))))).build();
    }

    public ProductionBinding producesMethodBinding(XMethodElement method, XTypeElement module) {
        XMethodType methodType = method.asMemberOf(module.getType());
        return (ProductionBinding)((ProductionBinding.Builder)((ProductionBinding.Builder)((ProductionBinding.Builder)((ProductionBinding.Builder)((ProductionBinding.Builder)ProductionBinding.builder().bindingElement(method)).contributingModule(module)).key(this.keyFactory.forProducesMethod(method, module))).executorRequest(this.dependencyRequestFactory.forProductionImplementationExecutor()).monitorRequest(this.dependencyRequestFactory.forProductionComponentMonitor()).explicitDependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forRequiredResolvedVariables(method.getParameters(), methodType.getParameterTypes())).scope(this.injectionAnnotations.getScope(method))).unresolved(methodType.isSameType(method.getExecutableType()) ? Optional.empty() : Optional.of(this.producesMethodBinding(method, XElements.asTypeElement(method.getEnclosingElement()))))).build();
    }

    public MultiboundMapBinding multiboundMap(Key key, Iterable<ContributionBinding> multibindingContributions) {
        return (MultiboundMapBinding)((MultiboundMapBinding.Builder)MultiboundMapBinding.builder().optionalBindingType(this.multibindingBindingType(key, multibindingContributions)).key(key)).dependencies(this.dependencyRequestFactory.forMultibindingContributions(key, multibindingContributions)).build();
    }

    public MultiboundSetBinding multiboundSet(Key key, Iterable<ContributionBinding> multibindingContributions) {
        return (MultiboundSetBinding)((MultiboundSetBinding.Builder)MultiboundSetBinding.builder().optionalBindingType(this.multibindingBindingType(key, multibindingContributions)).key(key)).dependencies(this.dependencyRequestFactory.forMultibindingContributions(key, multibindingContributions)).build();
    }

    private Optional<BindingType> multibindingBindingType(Key key, Iterable<ContributionBinding> multibindingContributions) {
        MapType mapType;
        if (MapType.isMap(key) ? (mapType = MapType.from(key)).valuesAreTypeOf(XTypeNames.PRODUCER) || mapType.valuesAreTypeOf(XTypeNames.PRODUCED) : SetType.isSet(key) && SetType.from(key).elementsAreTypeOf(XTypeNames.PRODUCED)) {
            return Optional.of(BindingType.PRODUCTION);
        }
        if (Iterables.any(multibindingContributions, binding -> binding.optionalBindingType().equals(Optional.of(BindingType.PRODUCTION)))) {
            return Optional.of(BindingType.PRODUCTION);
        }
        return Iterables.any(multibindingContributions, binding -> binding.optionalBindingType().isEmpty()) ? Optional.empty() : Optional.of(BindingType.PROVISION);
    }

    public ComponentBinding componentBinding(XTypeElement componentDefinitionType) {
        Preconditions.checkNotNull((Object)componentDefinitionType);
        return (ComponentBinding)((ComponentBinding.Builder)((ComponentBinding.Builder)ComponentBinding.builder().bindingElement(componentDefinitionType)).key(this.keyFactory.forType(componentDefinitionType.getType()))).build();
    }

    public ComponentDependencyBinding componentDependencyBinding(ComponentRequirement dependency) {
        Preconditions.checkNotNull((Object)dependency);
        return (ComponentDependencyBinding)((ComponentDependencyBinding.Builder)((ComponentDependencyBinding.Builder)ComponentDependencyBinding.builder().bindingElement(dependency.typeElement())).key(this.keyFactory.forType(dependency.type()))).build();
    }

    public ComponentDependencyProvisionBinding componentDependencyProvisionMethodBinding(XMethodElement dependencyMethod) {
        Preconditions.checkArgument((boolean)dependencyMethod.getParameters().isEmpty());
        return (ComponentDependencyProvisionBinding)((ComponentDependencyProvisionBinding.Builder)((ComponentDependencyProvisionBinding.Builder)((ComponentDependencyProvisionBinding.Builder)ComponentDependencyProvisionBinding.builder().key(this.keyFactory.forComponentMethod(dependencyMethod))).nullability(Nullability.of(dependencyMethod)).scope(this.injectionAnnotations.getScope(dependencyMethod))).bindingElement(dependencyMethod)).build();
    }

    public ComponentDependencyProductionBinding componentDependencyProductionMethodBinding(XMethodElement dependencyMethod) {
        Preconditions.checkArgument((boolean)dependencyMethod.getParameters().isEmpty());
        return (ComponentDependencyProductionBinding)((ComponentDependencyProductionBinding.Builder)((ComponentDependencyProductionBinding.Builder)ComponentDependencyProductionBinding.builder().key(this.keyFactory.forProductionComponentMethod(dependencyMethod))).bindingElement(dependencyMethod)).build();
    }

    BoundInstanceBinding boundInstanceBinding(ComponentRequirement requirement, XElement element) {
        Preconditions.checkArgument((XElementKt.isVariableElement(element) || XElementKt.isMethod(element) ? 1 : 0) != 0);
        XVariableElement parameterElement = XElementKt.isVariableElement(element) ? XElements.asVariable(element) : (XVariableElement)Iterables.getOnlyElement(XElements.asMethod(element).getParameters());
        return (BoundInstanceBinding)((BoundInstanceBinding.Builder)((BoundInstanceBinding.Builder)BoundInstanceBinding.builder().bindingElement(element)).key(requirement.key().get())).nullability(Nullability.of(parameterElement)).build();
    }

    SubcomponentCreatorBinding subcomponentCreatorBinding(XMethodElement subcomponentCreatorMethod, XTypeElement component) {
        Preconditions.checkArgument((boolean)subcomponentCreatorMethod.getParameters().isEmpty());
        Key key = this.keyFactory.forSubcomponentCreatorMethod(subcomponentCreatorMethod, component.getType());
        return (SubcomponentCreatorBinding)((SubcomponentCreatorBinding.Builder)((SubcomponentCreatorBinding.Builder)SubcomponentCreatorBinding.builder().bindingElement(subcomponentCreatorMethod)).key(key)).build();
    }

    SubcomponentCreatorBinding subcomponentCreatorBinding(ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
        SubcomponentDeclaration subcomponentDeclaration = (SubcomponentDeclaration)subcomponentDeclarations.iterator().next();
        return (SubcomponentCreatorBinding)((SubcomponentCreatorBinding.Builder)SubcomponentCreatorBinding.builder().key(subcomponentDeclaration.key())).build();
    }

    DelegateBinding delegateBinding(DelegateDeclaration delegateDeclaration) {
        return this.delegateBinding(delegateDeclaration, Optional.empty());
    }

    DelegateBinding delegateBinding(DelegateDeclaration delegateDeclaration, ContributionBinding actualBinding) {
        return this.delegateBinding(delegateDeclaration, this.delegateBindingType(Optional.of(actualBinding)));
    }

    private DelegateBinding delegateBinding(DelegateDeclaration delegateDeclaration, Optional<BindingType> optionalBindingType) {
        return (DelegateBinding)((DelegateBinding.Builder)((DelegateBinding.Builder)((DelegateBinding.Builder)((DelegateBinding.Builder)DelegateBinding.builder().contributionType(delegateDeclaration.contributionType()).bindingElement(delegateDeclaration.bindingElement().get())).contributingModule(delegateDeclaration.contributingModule().get())).delegateRequest(delegateDeclaration.delegateRequest()).nullability(Nullability.of(delegateDeclaration.bindingElement().get())).optionalBindingType(optionalBindingType).key(optionalBindingType.isEmpty() ? delegateDeclaration.key() : (optionalBindingType.get() == BindingType.PRODUCTION ? this.keyFactory.forDelegateBinding(delegateDeclaration, XTypeNames.PRODUCER) : this.keyFactory.forDelegateBinding(delegateDeclaration, XTypeNames.JAVAX_PROVIDER)))).scope(this.injectionAnnotations.getScope(delegateDeclaration.bindingElement().get()))).build();
    }

    public DelegateBinding unresolvedDelegateBinding(DelegateDeclaration delegateDeclaration) {
        return this.delegateBinding(delegateDeclaration, Optional.of(BindingType.PROVISION));
    }

    private Optional<BindingType> delegateBindingType(Optional<ContributionBinding> actualBinding) {
        if (actualBinding.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((actualBinding.get().bindingType() != BindingType.MEMBERS_INJECTION ? 1 : 0) != 0);
        return Optional.of(actualBinding.get().bindingType());
    }

    OptionalBinding syntheticPresentOptionalDeclaration(Key key, ImmutableCollection<Binding> optionalContributions) {
        Preconditions.checkArgument((!optionalContributions.isEmpty() ? 1 : 0) != 0);
        return (OptionalBinding)((OptionalBinding.Builder)OptionalBinding.builder().optionalBindingType(this.presentOptionalBindingType(key, optionalContributions)).key(key)).delegateRequest(this.dependencyRequestFactory.forSyntheticPresentOptionalBinding(key)).build();
    }

    private Optional<BindingType> presentOptionalBindingType(Key key, ImmutableCollection<Binding> optionalContributions) {
        RequestKind requestKind = RequestKinds.getRequestKind(OptionalType.from(key).valueType());
        if (requestKind.equals((Object)RequestKind.PRODUCER) || requestKind.equals((Object)RequestKind.PRODUCED)) {
            return Optional.of(BindingType.PRODUCTION);
        }
        if (optionalContributions.stream().filter(binding -> binding.optionalBindingType().isPresent()).anyMatch(binding -> binding.bindingType() == BindingType.PRODUCTION)) {
            return Optional.of(BindingType.PRODUCTION);
        }
        return optionalContributions.stream().anyMatch(binding -> binding.optionalBindingType().isEmpty()) ? Optional.empty() : Optional.of(BindingType.PROVISION);
    }

    OptionalBinding syntheticAbsentOptionalDeclaration(Key key) {
        return (OptionalBinding)((OptionalBinding.Builder)OptionalBinding.builder().key(key)).optionalBindingType(Optional.of(BindingType.PROVISION)).build();
    }

    public MembersInjectorBinding membersInjectorBinding(Key key, MembersInjectionBinding membersInjectionBinding) {
        return (MembersInjectorBinding)((MembersInjectorBinding.Builder)((MembersInjectorBinding.Builder)MembersInjectorBinding.builder().key(key)).bindingElement(membersInjectionBinding.key().type().xprocessing().getTypeElement())).injectionSites(membersInjectionBinding.injectionSites()).build();
    }

    public MembersInjectionBinding membersInjectionBinding(XType type, Optional<XType> resolvedType) {
        if (!type.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
            this.checkIsSameErasedType(resolvedType.get(), type);
            type = resolvedType.get();
        }
        return MembersInjectionBinding.builder().key(this.keyFactory.forMembersInjectedType(type)).injectionSites(this.injectionSiteFactory.getInjectionSites(type)).unresolved(BindingFactory.hasNonDefaultTypeParameters(type) ? Optional.of(this.membersInjectionBinding(type.getTypeElement().getType(), Optional.empty())) : Optional.empty()).build();
    }

    private void checkIsSameErasedType(XType type1, XType type2) {
        Preconditions.checkState((boolean)XTypes.erasedTypeName(type1).equals((Object)XTypes.erasedTypeName(type2)), (String)"erased expected type: %s, erased actual type: %s", (Object)XTypes.erasedTypeName(type1), (Object)XTypes.erasedTypeName(type2));
    }

    private static boolean hasNonDefaultTypeParameters(XType type) {
        if (!XTypes.isDeclared(type)) {
            return false;
        }
        XType defaultType = type.getTypeElement().getType();
        if (defaultType.getTypeArguments().isEmpty()) {
            return false;
        }
        if (defaultType.getTypeArguments().size() != type.getTypeArguments().size()) {
            return true;
        }
        for (int i = 0; i < defaultType.getTypeArguments().size(); ++i) {
            if (defaultType.getTypeArguments().get(i).isSameType(type.getTypeArguments().get(i))) continue;
            return true;
        }
        return false;
    }
}

