/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class XAnnotationSpecs {
    public static XAnnotationSpec of(XAnnotation annotation) {
        return XConverters.toXPoet(JavaPoetExtKt.toAnnotationSpec(annotation, false), AnnotationSpec.builder((ClassName)XConverters.toKotlinPoet(XAnnotations.asClassName(annotation))).build());
    }

    public static XAnnotationSpec of(XClassName className) {
        return XAnnotationSpecs.builder(className).build();
    }

    public static XAnnotationSpec suppressWarnings(Suppression first, Suppression ... rest) {
        return XAnnotationSpecs.suppressWarnings((ImmutableSet<Suppression>)ImmutableSet.copyOf((Collection)Lists.asList((Object)((Object)first), (Object[])rest)));
    }

    public static XAnnotationSpec suppressWarnings(ImmutableSet<Suppression> suppressions) {
        Preconditions.checkArgument((!suppressions.isEmpty() ? 1 : 0) != 0);
        Builder javaBuilder = XAnnotationSpecs.builder(XTypeName.SUPPRESS);
        Builder kotlinBuilder = XAnnotationSpecs.builder(XTypeName.SUPPRESS);
        for (Suppression suppression : suppressions) {
            javaBuilder.addArrayMember("value", "%S", suppression.javaName);
            if (suppression == Suppression.KOTLIN_INTERNAL) {
                javaBuilder.addArrayMember("value", "%S", "KotlinInternalInJava");
            }
            suppression.kotlinName.ifPresent(name -> kotlinBuilder.addArrayMember("names", "%S", name));
        }
        return XConverters.toXPoet(XConverters.toJavaPoet(javaBuilder.build()), XConverters.toKotlinPoet(kotlinBuilder.build()));
    }

    public static Builder builder(XClassName className) {
        return new Builder(className);
    }

    private XAnnotationSpecs() {
    }

    public static final class Builder {
        private final XClassName className;
        private final Set<String> nonArrayMembers = new HashSet<String>();
        private final ListMultimap<String, XCodeBlock> members = LinkedListMultimap.create();

        Builder(XClassName className) {
            this.className = className;
        }

        @CanIgnoreReturnValue
        public Builder addMember(String name, String format, Object ... args) {
            return this.addMember(name, XCodeBlock.of(format, args));
        }

        @CanIgnoreReturnValue
        public Builder addMember(String name, XCodeBlock value) {
            Preconditions.checkState((boolean)this.nonArrayMembers.add(name));
            Preconditions.checkState((!this.members.containsKey((Object)name) ? 1 : 0) != 0);
            this.members.put((Object)name, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addArrayMember(String name, String format, Object ... args) {
            return this.addArrayMember(name, XCodeBlock.of(format, args));
        }

        @CanIgnoreReturnValue
        public Builder addArrayMember(String name, XCodeBlock value) {
            Preconditions.checkState((!this.nonArrayMembers.contains(name) ? 1 : 0) != 0);
            this.members.put((Object)name, (Object)value);
            return this;
        }

        public XAnnotationSpec build() {
            XAnnotationSpec.Builder builder = XAnnotationSpec.builder(this.className);
            for (String name : this.members.keySet()) {
                for (XCodeBlock value : this.members.get((Object)name)) {
                    XConverters.toJavaPoet(builder).addMember(name, XConverters.toJavaPoet(value));
                }
            }
            for (String name : this.members.keySet()) {
                List values = this.members.get((Object)name);
                if (this.nonArrayMembers.contains(name)) {
                    XConverters.toKotlinPoet(builder).addMember("%L = %L", new Object[]{name, XConverters.toKotlinPoet((XCodeBlock)values.get(0))});
                    continue;
                }
                if (values.size() == 1) {
                    XConverters.toKotlinPoet(builder).addMember("%L = [%L]", new Object[]{name, XConverters.toKotlinPoet((XCodeBlock)values.get(0))});
                    continue;
                }
                XConverters.toKotlinPoet(builder).addMember("%L = [\n\u21e5\u21e5%L\u21e4\u21e4\n]", new Object[]{name, XConverters.toKotlinPoet(this.formattedList(values))});
            }
            return builder.build();
        }

        private XCodeBlock formattedList(List<XCodeBlock> values) {
            XCodeBlock.Builder builder = XCodeBlock.builder();
            for (int i = 0; i < values.size(); ++i) {
                builder.add(values.get(i));
                if (values.size() <= 1 || i >= values.size() - 1) continue;
                builder.add(",\n", new Object[0]);
            }
            return builder.build();
        }
    }

    public static enum Suppression {
        RAWTYPES("rawtypes"),
        UNCHECKED("unchecked", "UNCHECKED_CAST"),
        FUTURE_RETURN_VALUE_IGNORED("FutureReturnValueIgnored"),
        KOTLIN_INTERNAL("KotlinInternal"),
        CAST("cast", "USELESS_CAST"),
        DEPRECATION("deprecation", "DEPRECATION"),
        UNINITIALIZED("nullness:initialization.field.uninitialized");

        private final String javaName;
        private final Optional<String> kotlinName;

        private Suppression(String javaName) {
            this(javaName, Optional.empty());
        }

        private Suppression(String javaName, String kotlinName) {
            this(javaName, Optional.of(kotlinName));
        }

        private Suppression(String javaName, Optional<String> kotlinName) {
            this.javaName = javaName;
            this.kotlinName = kotlinName;
        }
    }
}

