/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Optional;

public final class Accessibility {
    public static boolean isTypeAccessibleFromPublicApi(XType type, CompilerOptions compilerOptions) {
        return true;
    }

    public static boolean isTypePubliclyAccessible(XType type, CompilerOptions compilerOptions) {
        return Accessibility.isTypePubliclyAccessible(type);
    }

    public static boolean isTypePubliclyAccessible(XType type) {
        return Accessibility.isTypeAccessibleFrom(type, Optional.empty());
    }

    public static boolean isTypeAccessibleFrom(XType type, String packageName) {
        return Accessibility.isTypeAccessibleFrom(type, Optional.of(packageName));
    }

    private static boolean isTypeAccessibleFrom(XType type, Optional<String> packageName) {
        if (XTypes.isNoType(type) || XTypes.isPrimitive(type) || XTypes.isNullType(type) || XTypes.isTypeVariable(type)) {
            return true;
        }
        if (XTypeKt.isArray(type)) {
            return Accessibility.isTypeAccessibleFrom(XTypes.asArray(type).getComponentType(), packageName);
        }
        if (XTypes.isDeclared(type)) {
            XType enclosingType = XTypes.getEnclosingType(type);
            if (enclosingType != null && !Accessibility.isTypeAccessibleFrom(enclosingType, packageName)) {
                return false;
            }
            if (!Accessibility.isElementAccessibleFrom((XElement)type.getTypeElement(), packageName)) {
                return false;
            }
            return type.getTypeArguments().stream().allMatch(typeArgument -> Accessibility.isTypeAccessibleFrom(typeArgument, packageName));
        }
        if (XTypes.isWildcard(type)) {
            return type.extendsBound() == null || Accessibility.isTypeAccessibleFrom(type.extendsBound(), packageName);
        }
        throw new AssertionError((Object)String.format("%s should not be checked for accessibility", type));
    }

    public static boolean isElementPubliclyAccessible(XElement element) {
        return Accessibility.isElementAccessibleFrom(element, Optional.empty());
    }

    public static boolean isElementAccessibleFrom(XElement element, String packageName) {
        return Accessibility.isElementAccessibleFrom(element, Optional.of(packageName));
    }

    private static boolean isElementAccessibleFrom(XElement element, Optional<String> packageName) {
        if (XElements.isPackage(element)) {
            return true;
        }
        if (XElementKt.isTypeElement(element)) {
            return XTypeElements.isNested(XElements.asTypeElement(element)) ? Accessibility.accessibleMember(element, packageName) : Accessibility.accessibleModifiers(element, packageName);
        }
        if (XElements.isExecutable(element) || XElementKt.isField(element)) {
            return Accessibility.accessibleMember(element, packageName);
        }
        throw new AssertionError();
    }

    private static boolean accessibleMember(XElement element, Optional<String> packageName) {
        return Accessibility.isElementAccessibleFrom(element.getEnclosingElement(), packageName) && Accessibility.accessibleModifiers(element, packageName);
    }

    private static boolean accessibleModifiers(XElement element, Optional<String> packageName) {
        if (XElements.isPublic(element)) {
            return true;
        }
        if (XElements.isPrivate(element)) {
            return false;
        }
        XMemberContainer container = element.getClosestMemberContainer();
        return packageName.isPresent() && container.isFromJava() && container.getClassName().packageName().contentEquals(packageName.get());
    }

    public static boolean isRawTypeAccessible(XType type, String requestingPackage) {
        return XTypes.isDeclared(type) ? Accessibility.isElementAccessibleFrom((XElement)type.getTypeElement(), requestingPackage) : Accessibility.isTypeAccessibleFrom(type, requestingPackage);
    }

    public static boolean isRawTypePubliclyAccessible(XType type) {
        return XTypes.isDeclared(type) ? Accessibility.isElementPubliclyAccessible(type.getTypeElement()) : Accessibility.isTypePubliclyAccessible(type);
    }

    public static XTypeName accessibleTypeName(XType type, XClassName requestingClass, XProcessingEnv processingEnv) {
        if (Accessibility.isTypeAccessibleFrom(type, requestingClass.getPackageName())) {
            return type.asTypeName();
        }
        if (XTypes.isDeclared(type) && Accessibility.isRawTypeAccessible(type, requestingClass.getPackageName())) {
            return type.getRawType().asTypeName();
        }
        return XTypeName.ANY_OBJECT;
    }

    private Accessibility() {
    }
}

