/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;

public enum ModuleKind {
    MODULE(XTypeNames.MODULE),
    PRODUCER_MODULE(XTypeNames.PRODUCER_MODULE);

    private final XClassName moduleAnnotation;

    private static ImmutableSet<XClassName> annotationsFor(Set<ModuleKind> kinds) {
        return (ImmutableSet)kinds.stream().map(ModuleKind::annotation).collect(DaggerStreams.toImmutableSet());
    }

    public static Optional<ModuleKind> forAnnotatedElement(XTypeElement element) {
        EnumSet<ModuleKind> kinds = EnumSet.noneOf(ModuleKind.class);
        for (ModuleKind kind : ModuleKind.values()) {
            if (!element.hasAnnotation(kind.annotation())) continue;
            kinds.add(kind);
        }
        if (kinds.size() > 1) {
            throw new IllegalArgumentException(element + " cannot be annotated with more than one of " + ModuleKind.annotationsFor(kinds));
        }
        return kinds.stream().findAny();
    }

    public static void checkIsModule(XTypeElement moduleElement) {
        if (moduleElement.isCompanionObject()) {
            Preconditions.checkArgument((boolean)ModuleKind.forAnnotatedElement(moduleElement.getEnclosingTypeElement()).isPresent());
        } else {
            Preconditions.checkArgument((boolean)ModuleKind.forAnnotatedElement(moduleElement).isPresent());
        }
    }

    private ModuleKind(XClassName moduleAnnotation) {
        this.moduleAnnotation = moduleAnnotation;
    }

    public XAnnotation getModuleAnnotation(XTypeElement element) {
        Preconditions.checkArgument((boolean)element.hasAnnotation(this.moduleAnnotation), (String)"annotation %s is not present on type %s", (Object)this.moduleAnnotation, (Object)element);
        return element.getAnnotation(this.moduleAnnotation);
    }

    public XClassName annotation() {
        return this.moduleAnnotation;
    }

    public ImmutableSet<ModuleKind> legalIncludedModuleKinds() {
        switch (this.ordinal()) {
            case 0: {
                return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new ModuleKind[0]);
            }
            case 1: {
                return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new ModuleKind[]{PRODUCER_MODULE});
            }
        }
        throw new AssertionError((Object)this);
    }
}

