/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.VisibilityModifier;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class FactoryGenerator
extends SourceFileGenerator<ContributionBinding> {
    private static final ImmutableSet<BindingKind> VALID_BINDING_KINDS = ImmutableSet.of((Object)((Object)BindingKind.INJECTION), (Object)((Object)BindingKind.ASSISTED_INJECTION), (Object)((Object)BindingKind.PROVISION));
    private final CompilerOptions compilerOptions;
    private final SourceFiles sourceFiles;

    @Inject
    FactoryGenerator(XFiler filer, CompilerOptions compilerOptions, SourceFiles sourceFiles, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
        this.compilerOptions = compilerOptions;
        this.sourceFiles = sourceFiles;
    }

    @Override
    public XElement originatingElement(ContributionBinding binding) {
        return binding.bindingElement().get();
    }

    @Override
    public ImmutableList<XTypeSpec> topLevelTypes(ContributionBinding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        Preconditions.checkArgument((boolean)VALID_BINDING_KINDS.contains((Object)binding.kind()));
        return ImmutableList.of((Object)this.factoryBuilder(binding));
    }

    private XTypeSpec factoryBuilder(ContributionBinding binding) {
        XTypeSpecs.Builder factoryBuilder = XTypeSpecs.classBuilder(SourceFiles.generatedClassNameForBinding(binding)).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypeVariableNames((Collection<XTypeName>)SourceFiles.bindingTypeElementTypeVariableNames(binding)).addAnnotation(this.scopeMetadataAnnotation(binding)).addAnnotation(this.qualifierMetadataAnnotation(binding));
        FactoryGenerator.factoryTypeName(binding).ifPresent(factoryBuilder::addSuperinterface);
        FactoryFields factoryFields = FactoryFields.create(binding);
        if (factoryFields.isEmpty()) {
            factoryBuilder.addType(this.staticInstanceHolderType(binding));
        } else {
            factoryBuilder.addProperties((Collection<XPropertySpec>)factoryFields.getAll()).addFunction(this.constructorMethod(factoryFields));
        }
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(factoryBuilder::addAnnotation);
        return factoryBuilder.addFunction(this.getMethod(binding, factoryFields)).addFunction(this.staticCreateMethod(binding, factoryFields)).addFunction(this.staticProxyMethod(binding)).build();
    }

    private XTypeSpec staticInstanceHolderType(ContributionBinding binding) {
        XClassName generatedClassName = SourceFiles.generatedClassNameForBinding(binding);
        XPropertySpecs.Builder instanceHolderFieldBuilder = XPropertySpecs.builder("INSTANCE", (XTypeName)generatedClassName, Modifier.STATIC, Modifier.FINAL).initializer(XCodeBlock.ofNewInstance((XTypeName)generatedClassName, (String)"", (Object[])new Object[0]));
        if (!SourceFiles.bindingTypeElementTypeVariableNames(binding).isEmpty()) {
            instanceHolderFieldBuilder.addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.RAWTYPES, new XAnnotationSpecs.Suppression[0]));
        }
        return XTypeSpecs.classBuilder(FactoryGenerator.instanceHolderClassName(binding)).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addProperty(instanceHolderFieldBuilder.build()).build();
    }

    private static XClassName instanceHolderClassName(ContributionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding).nestedClass("InstanceHolder");
    }

    private XFunSpec constructorMethod(FactoryFields factoryFields) {
        XFunSpecs.Builder constructor = XFunSpecs.constructorBuilder().addModifiers(Modifier.PUBLIC);
        factoryFields.getAll().forEach(field -> constructor.addParameter(field.getName(), field.getType()).addStatement("this.%1N = %1N", field));
        return constructor.build();
    }

    private XFunSpec staticCreateMethod(ContributionBinding binding, FactoryFields factoryFields) {
        XFunSpecs.Builder createMethodBuilder = XFunSpecs.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)).addTypeVariableNames((Collection<XTypeName>)SourceFiles.bindingTypeElementTypeVariableNames(binding));
        if (factoryFields.isEmpty()) {
            if (!SourceFiles.bindingTypeElementTypeVariableNames(binding).isEmpty()) {
                createMethodBuilder.addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.UNCHECKED, new XAnnotationSpecs.Suppression[0]));
            }
            createMethodBuilder.addStatement("return %T.INSTANCE", FactoryGenerator.instanceHolderClassName(binding));
        } else {
            ImmutableList parameters = (ImmutableList)factoryFields.getAll().stream().map(field -> XParameterSpecs.of(field.getName(), field.getType())).collect(DaggerStreams.toImmutableList());
            createMethodBuilder.addParameters((Collection<XParameterSpec>)parameters).addStatement("return %L", XCodeBlock.ofNewInstance((XTypeName)SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), (String)"%L", (Object[])new Object[]{XCodeBlocks.parameterNames((Iterable<XParameterSpec>)parameters)}));
        }
        return createMethodBuilder.build();
    }

    private XFunSpec getMethod(ContributionBinding binding, FactoryFields factoryFields) {
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        factoryFields.getAll().forEach(field -> uniqueFieldNames.claim(field.getName()));
        ImmutableMap assistedParameters = (ImmutableMap)AssistedInjectionAnnotations.assistedParameters(binding).stream().collect(DaggerStreams.toImmutableMap(parameter -> parameter, parameter -> XParameterSpecs.of(uniqueFieldNames.getUniqueName(parameter.getJvmName()), parameter.getType().asTypeName())));
        XTypeName providedTypeName = FactoryGenerator.providedTypeName(binding);
        XFunSpecs.Builder getMethod = XFunSpecs.methodBuilder("get").addModifiers(Modifier.PUBLIC).addParameters((Collection<XParameterSpec>)assistedParameters.values());
        if (FactoryGenerator.factoryTypeName(binding).isPresent()) {
            getMethod.addAnnotation(Override.class);
        }
        XCodeBlock invokeNewInstance = InjectionMethods.ProvisionMethod.invoke(binding, request -> this.sourceFiles.frameworkTypeUsageStatement(XCodeBlock.of((String)"%N", (Object[])new Object[]{factoryFields.get((DependencyRequest)request)}), request.kind()), param -> ((XParameterSpec)assistedParameters.get(param)).getName(), SourceFiles.generatedClassNameForBinding(binding), factoryFields.moduleField.map(module -> XCodeBlock.of((String)"%N", (Object[])new Object[]{module})), this.compilerOptions);
        if (binding.kind().equals((Object)BindingKind.PROVISION)) {
            getMethod.addAnnotationNames((Collection<XClassName>)binding.nullability().nonTypeUseNullableAnnotations()).addStatement("return %L", invokeNewInstance).returns(providedTypeName);
        } else if (!this.injectionSites(binding).isEmpty()) {
            XCodeBlock instance = XCodeBlock.of((String)"instance", (Object[])new Object[0]);
            XCodeBlock invokeInjectionSites = InjectionMethods.InjectionSiteMethod.invokeAll(this.injectionSites(binding), SourceFiles.generatedClassNameForBinding(binding), instance, binding.key().type().xprocessing(), arg_0 -> this.sourceFiles.frameworkFieldUsages(binding.dependencies(), (ImmutableMap<DependencyRequest, XPropertySpec>)factoryFields.frameworkFields).get(arg_0));
            getMethod.returns(providedTypeName).addStatement("%T %L = %L", providedTypeName, instance, invokeNewInstance).addCode(invokeInjectionSites).addStatement("return %L", instance);
        } else {
            getMethod.returns(providedTypeName).addStatement("return %L", invokeNewInstance);
        }
        return getMethod.build();
    }

    private XFunSpec staticProxyMethod(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: 
            case ASSISTED_INJECTION: {
                return FactoryGenerator.staticProxyMethodForInjection(binding);
            }
            case PROVISION: {
                return this.staticProxyMethodForProvision((ProvisionBinding)binding);
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + binding));
    }

    private static XFunSpec staticProxyMethodForInjection(ContributionBinding binding) {
        XConstructorElement constructor = XElements.asConstructor(binding.bindingElement().get());
        XTypeElement enclosingType = constructor.getEnclosingElement();
        XFunSpecs.Builder builder = XFunSpecs.methodBuilder(SourceFiles.generatedProxyMethodName(binding)).addModifiers(Modifier.PUBLIC, Modifier.STATIC).varargs(constructor.isVarArgs()).returns(enclosingType.getType().getTypeName()).addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(enclosingType)).addExceptions(constructor.getThrownTypes());
        XCodeBlock arguments = InjectionMethods.copyParameters(builder, new UniqueNameSet(), constructor.getParameters());
        return builder.addStatement("return %L", XCodeBlock.ofNewInstance((XTypeName)enclosingType.getType().asTypeName(), (String)"%L", (Object[])new Object[]{arguments})).build();
    }

    private XFunSpec staticProxyMethodForProvision(ProvisionBinding binding) {
        XCodeBlock module;
        XMethodElement method = XElements.asMethod(binding.bindingElement().get());
        XFunSpecs.Builder builder = XFunSpecs.methodBuilder(SourceFiles.generatedProxyMethodName(binding)).addModifiers(Modifier.PUBLIC, Modifier.STATIC).varargs(method.isVarArgs()).addExceptions(method.getThrownTypes());
        XTypeElement enclosingType = XElements.asTypeElement((XElement)method.getEnclosingElement());
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        if (method.isStatic() || enclosingType.isCompanionObject()) {
            module = XCodeBlock.of((String)"%T", (Object[])new Object[]{enclosingType.asClassName()});
        } else if (enclosingType.isKotlinObject()) {
            module = XCodeBlock.of((String)"%T.INSTANCE", (Object[])new Object[]{enclosingType.asClassName()});
        } else {
            builder.addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(enclosingType));
            module = FactoryGenerator.copyInstance(builder, parameterNameSet, enclosingType.getType());
        }
        XCodeBlock arguments = InjectionMethods.copyParameters(builder, parameterNameSet, method.getParameters());
        XCodeBlock invocation = XCodeBlock.of((String)"%L.%L(%L)", (Object[])new Object[]{module, method.getJvmName(), arguments});
        Nullability nullability = Nullability.of((XElement)method);
        return builder.addAnnotationNames((Collection<XClassName>)nullability.nonTypeUseNullableAnnotations()).returns(XTypeNames.withTypeNullability(method.getReturnType().asTypeName(), nullability)).addStatement("return %L", this.maybeWrapInCheckForNull(binding, invocation)).build();
    }

    private XCodeBlock maybeWrapInCheckForNull(ProvisionBinding binding, XCodeBlock codeBlock) {
        return binding.shouldCheckForNull(this.compilerOptions) ? XCodeBlock.of((String)"%T.checkNotNullFromProvides(%L)", (Object[])new Object[]{XTypeNames.DAGGER_PRECONDITIONS, codeBlock}) : codeBlock;
    }

    private static XCodeBlock copyInstance(XFunSpecs.Builder methodBuilder, UniqueNameSet parameterNameSet, XType type) {
        return InjectionMethods.copyParameter(methodBuilder, type, parameterNameSet.getUniqueName("instance"), false, Nullability.NOT_NULLABLE);
    }

    private XAnnotationSpec scopeMetadataAnnotation(ContributionBinding binding) {
        XAnnotationSpec.Builder builder = XAnnotationSpec.builder((XClassName)XTypeNames.SCOPE_METADATA);
        binding.scope().map(Scope::scopeAnnotation).map(DaggerAnnotation::xprocessing).map(XAnnotation::getQualifiedName).ifPresent(scopeCanonicalName -> builder.addMember("value", "%S", new Object[]{scopeCanonicalName}));
        return builder.build();
    }

    private XAnnotationSpec qualifierMetadataAnnotation(ContributionBinding binding) {
        XAnnotationSpec.Builder builder = XAnnotationSpec.builder((XClassName)XTypeNames.QUALIFIER_METADATA);
        Stream.concat(Stream.of(binding.key()), this.provisionDependencies(binding).stream().map(DependencyRequest::key)).map(Key::qualifier).flatMap(DaggerStreams.presentValues()).map(DaggerAnnotation::xprocessing).map(XAnnotation::getQualifiedName).distinct().forEach(qualifier -> builder.addMember("value", "%S", new Object[]{qualifier}));
        return builder.build();
    }

    private ImmutableSet<DependencyRequest> provisionDependencies(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: {
                return ((InjectionBinding)binding).constructorDependencies();
            }
            case ASSISTED_INJECTION: {
                return ((AssistedInjectionBinding)binding).constructorDependencies();
            }
            case PROVISION: {
                return ((ProvisionBinding)binding).dependencies();
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
    }

    private ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: {
                return ((InjectionBinding)binding).injectionSites();
            }
            case ASSISTED_INJECTION: {
                return ((AssistedInjectionBinding)binding).injectionSites();
            }
            case PROVISION: {
                return ImmutableSet.of();
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
    }

    private static XTypeName providedTypeName(ContributionBinding binding) {
        return XTypeNames.withTypeNullability(binding.contributedType().asTypeName(), binding.nullability());
    }

    private static Optional<XTypeName> factoryTypeName(ContributionBinding binding) {
        return binding.kind() == BindingKind.ASSISTED_INJECTION ? Optional.empty() : Optional.of(XTypeNames.factoryOf(FactoryGenerator.providedTypeName(binding)));
    }

    private static final class FactoryFields {
        private final Optional<XPropertySpec> moduleField;
        private final ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields;

        static FactoryFields create(ContributionBinding binding) {
            UniqueNameSet nameSet = new UniqueNameSet();
            Optional<XPropertySpec> moduleField = binding.requiresModuleInstance() ? Optional.of(FactoryFields.createField(binding.bindingTypeElement().get().getType().asTypeName(), nameSet.getUniqueName("module"))) : Optional.empty();
            ImmutableMap.Builder frameworkFields = ImmutableMap.builder();
            SourceFiles.generateBindingFieldsForDependencies(binding).forEach((dependency, field) -> frameworkFields.put(dependency, (Object)FactoryFields.createField(field.type(), nameSet.getUniqueName(field.name()))));
            return new FactoryFields(moduleField, (ImmutableMap<DependencyRequest, XPropertySpec>)frameworkFields.buildOrThrow());
        }

        private static XPropertySpec createField(XTypeName typeName, String name) {
            return XPropertySpec.builder((String)name, (XTypeName)typeName, (VisibilityModifier)VisibilityModifier.PRIVATE, (boolean)false, (boolean)false).build();
        }

        private FactoryFields(Optional<XPropertySpec> moduleField, ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
            this.moduleField = moduleField;
            this.frameworkFields = frameworkFields;
        }

        XPropertySpec get(DependencyRequest request) {
            return (XPropertySpec)this.frameworkFields.get((Object)request);
        }

        ImmutableList<XPropertySpec> getAll() {
            return this.moduleField.isPresent() ? ImmutableList.builder().add((Object)this.moduleField.get()).addAll((Iterable)this.frameworkFields.values()).build() : this.frameworkFields.values().asList();
        }

        boolean isEmpty() {
            return this.getAll().isEmpty();
        }
    }
}

