/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.MultiboundMapBinding;
import dagger.internal.codegen.binding.MultiboundSetBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Collection;

final class StaticMemberSelects {
    static MemberSelect emptyMapFactory(MultiboundMapBinding binding) {
        BindingType bindingType = binding.bindingType();
        ImmutableList typeParameters = ImmutableList.copyOf((Collection)binding.key().type().xprocessing().getTypeArguments());
        return bindingType.equals((Object)BindingType.PRODUCTION) ? new ParameterizedStaticMethod(XTypeNames.PRODUCERS, (ImmutableList<XType>)typeParameters, CodeBlock.of((String)"emptyMapProducer()", (Object[])new Object[0]), XTypeNames.PRODUCER) : new ParameterizedStaticMethod(XTypeNames.MAP_FACTORY, (ImmutableList<XType>)typeParameters, CodeBlock.of((String)"emptyMapProvider()", (Object[])new Object[0]), XTypeNames.DAGGER_PROVIDER);
    }

    static MemberSelect emptySetFactory(MultiboundSetBinding binding) {
        return new ParameterizedStaticMethod(SourceFiles.setFactoryClassName(binding), (ImmutableList<XType>)ImmutableList.of((Object)SetType.from(binding.key()).elementType()), CodeBlock.of((String)"empty()", (Object[])new Object[0]), XTypeNames.FACTORY);
    }

    static MemberSelect factoryCreateNoArgumentMethod(Binding binding) {
        ImmutableList<XTypeName> typeVariables;
        Preconditions.checkArgument((boolean)binding.bindingType().equals((Object)BindingType.PROVISION), (String)"Invalid binding type: %s", (Object)((Object)binding.bindingType()));
        Preconditions.checkArgument((binding.dependencies().isEmpty() && !binding.scope().isPresent() ? 1 : 0) != 0, (String)"%s should have no dependencies and be unscoped to create a no argument factory.", (Object)binding);
        XClassName factoryName = SourceFiles.generatedClassNameForBinding(binding);
        XType keyType = binding.key().type().xprocessing();
        if (XTypes.isDeclared(keyType) && !(typeVariables = SourceFiles.bindingTypeElementTypeVariableNames(binding)).isEmpty()) {
            ImmutableList typeArguments = ImmutableList.copyOf((Collection)keyType.getTypeArguments());
            return new ParameterizedStaticMethod(factoryName, (ImmutableList<XType>)typeArguments, CodeBlock.of((String)"create()", (Object[])new Object[0]), XTypeNames.FACTORY);
        }
        return new StaticMethod(factoryName, CodeBlock.of((String)"create()", (Object[])new Object[0]));
    }

    private StaticMemberSelects() {
    }

    private static final class ParameterizedStaticMethod
    extends MemberSelect {
        private final ImmutableList<XType> typeParameters;
        private final CodeBlock methodCodeBlock;
        private final XClassName rawReturnType;

        ParameterizedStaticMethod(XClassName owningClass, ImmutableList<XType> typeParameters, CodeBlock methodCodeBlock, XClassName rawReturnType) {
            super(owningClass, true);
            this.typeParameters = typeParameters;
            this.methodCodeBlock = methodCodeBlock;
            this.rawReturnType = rawReturnType;
        }

        @Override
        CodeBlock getExpressionFor(XClassName usingClass) {
            boolean isAccessible = this.typeParameters.stream().allMatch(t -> Accessibility.isTypeAccessibleFrom(t, usingClass.getPackageName()));
            if (isAccessible) {
                return CodeBlock.of((String)"$T.<$L>$L", (Object[])new Object[]{XConverters.toJavaPoet((XClassName)this.owningClass()), this.typeParameters.stream().map(CodeBlocks::type).collect(CodeBlocks.toParametersCodeBlock()), this.methodCodeBlock});
            }
            return CodeBlock.of((String)"(($T) $T.$L)", (Object[])new Object[]{XConverters.toJavaPoet((XClassName)this.rawReturnType), XConverters.toJavaPoet((XClassName)this.owningClass()), this.methodCodeBlock});
        }
    }

    private static final class StaticMethod
    extends MemberSelect {
        private final CodeBlock methodCodeBlock;

        StaticMethod(XClassName owningClass, CodeBlock methodCodeBlock) {
            super(owningClass, true);
            this.methodCodeBlock = (CodeBlock)Preconditions.checkNotNull((Object)methodCodeBlock);
        }

        @Override
        CodeBlock getExpressionFor(XClassName usingClass) {
            return this.owningClass().equals((Object)usingClass) ? this.methodCodeBlock : CodeBlock.of((String)"$T.$L", (Object[])new Object[]{XConverters.toJavaPoet((XClassName)this.owningClass()), this.methodCodeBlock});
        }
    }
}

