/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

public final class OptionalType {
    private final XType type;

    public static OptionalType from(Key key) {
        return OptionalType.from(key.type().xprocessing());
    }

    public static OptionalType from(XType type) {
        Preconditions.checkArgument((boolean)OptionalType.isOptional(type), (String)"%s must be an Optional", (Object)type);
        return new OptionalType(type);
    }

    private OptionalType(XType type) {
        this.type = type;
    }

    XTypeName typeName() {
        return this.type.asTypeName();
    }

    public OptionalKind kind() {
        return OptionalKind.of(this.type.getTypeElement());
    }

    public XType valueType() {
        return (XType)this.type.getTypeArguments().get(0);
    }

    private static boolean isOptional(XType type) {
        return XTypes.isDeclared(type) && OptionalKind.isOptionalKind(type.getTypeElement());
    }

    public static boolean isOptional(Key key) {
        return OptionalType.isOptional(key.type().xprocessing());
    }

    public static boolean isOptionalProviderType(XType type) {
        OptionalType optionalType;
        return OptionalType.isOptional(type) && XTypes.isTypeOf((optionalType = OptionalType.from(type)).valueType(), XTypeNames.PROVIDER);
    }

    public static enum OptionalKind {
        GUAVA_OPTIONAL(XTypeNames.GUAVA_OPTIONAL, "absent"),
        JDK_OPTIONAL(XTypeNames.JDK_OPTIONAL, "empty");

        private static final ImmutableMap<XClassName, OptionalKind> OPTIONAL_KIND_BY_CLASS_NAME;
        private final XClassName className;
        private final String absentMethodName;

        private OptionalKind(XClassName className, String absentMethodName) {
            this.className = className;
            this.absentMethodName = absentMethodName;
        }

        private static boolean isOptionalKind(XTypeElement type) {
            return OPTIONAL_KIND_BY_CLASS_NAME.containsKey((Object)type.asClassName());
        }

        private static OptionalKind of(XTypeElement type) {
            return (OptionalKind)((Object)OPTIONAL_KIND_BY_CLASS_NAME.get((Object)type.asClassName()));
        }

        public XClassName className() {
            return this.className;
        }

        public XTypeName of(XTypeName valueType) {
            return this.className.parametrizedBy(new XTypeName[]{valueType});
        }

        public CodeBlock absentValueExpression() {
            return CodeBlock.of((String)"$T.$L()", (Object[])new Object[]{XTypeNameKt.toJavaPoet((XClassName)this.className), this.absentMethodName});
        }

        public CodeBlock parameterizedAbsentValueExpression(OptionalType optionalType) {
            return CodeBlock.of((String)"$T.<$T>$L()", (Object[])new Object[]{XTypeNameKt.toJavaPoet((XClassName)this.className), XTypeNameKt.toJavaPoet((XTypeName)optionalType.valueType().asTypeName()), this.absentMethodName});
        }

        public CodeBlock presentExpression(CodeBlock value) {
            return CodeBlock.of((String)"$T.of($L)", (Object[])new Object[]{XTypeNameKt.toJavaPoet((XClassName)this.className), value});
        }

        public CodeBlock presentObjectExpression(CodeBlock value) {
            return CodeBlock.of((String)"$T.<$T>of($L)", (Object[])new Object[]{XTypeNameKt.toJavaPoet((XClassName)this.className), XTypeNameKt.toJavaPoet((XTypeName)XTypeName.ANY_OBJECT), value});
        }

        static {
            OPTIONAL_KIND_BY_CLASS_NAME = (ImmutableMap)DaggerStreams.valuesOf(OptionalKind.class).collect(DaggerStreams.toImmutableMap(value -> value.className, value -> value));
        }
    }
}

