/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.writing.LazyMapKeyProxyGenerator;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

final class LazyClassKeyProcessingStep
extends TypeCheckingProcessingStep<XElement> {
    private static final String PROGUARD_KEEP_RULE = "-keep,allowobfuscation,allowshrinking class ";
    private final SetMultimap<ClassName, ClassName> lazyMapKeysByModule = LinkedHashMultimap.create();
    private final LazyMapKeyProxyGenerator lazyMapKeyProxyGenerator;

    @Inject
    LazyClassKeyProcessingStep(LazyMapKeyProxyGenerator lazyMapKeyProxyGenerator) {
        this.lazyMapKeyProxyGenerator = lazyMapKeyProxyGenerator;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.LAZY_CLASS_KEY);
    }

    @Override
    protected void process(XElement element, ImmutableSet<ClassName> annotations) {
        ClassName lazyClassKey = element.getAnnotation(TypeNames.LAZY_CLASS_KEY).getAsType("value").getTypeElement().getClassName();
        if (!LazyClassKeyProcessingStep.isMapBinding(element) || !LazyClassKeyProcessingStep.isModuleOrProducerModule(element.getEnclosingElement())) {
            return;
        }
        XTypeElement moduleElement = XElements.asTypeElement(element.getEnclosingElement());
        this.lazyMapKeysByModule.put((Object)moduleElement.getClassName(), (Object)lazyClassKey);
        XMethodElement method = XElements.asMethod(element);
        this.lazyMapKeyProxyGenerator.generate(method);
    }

    private static boolean isMapBinding(XElement element) {
        return element.hasAnnotation(TypeNames.INTO_MAP) && (element.hasAnnotation(TypeNames.BINDS) || element.hasAnnotation(TypeNames.PROVIDES) || element.hasAnnotation(TypeNames.PRODUCES));
    }

    private static boolean isModuleOrProducerModule(XElement element) {
        return XElementKt.isTypeElement((XElement)element) && (element.hasAnnotation(TypeNames.MODULE) || element.hasAnnotation(TypeNames.PRODUCER_MODULE));
    }

    @Override
    public void processOver(XProcessingEnv env, Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        super.processOver(env, elementsByAnnotation);
        this.lazyMapKeysByModule.asMap().forEach((moduleClassName, lazyClassKeys) -> {
            XTypeElement originatingElement = env.requireTypeElement(moduleClassName.canonicalName());
            Path proguardFile = Path.of("META-INF/proguard", LazyClassKeyProcessingStep.getFullyQualifiedEnclosedClassName(moduleClassName) + "_LazyClassKeys.pro");
            String proguardFileContents = lazyClassKeys.stream().map(lazyClassKey -> PROGUARD_KEEP_RULE + lazyClassKey.canonicalName()).collect(Collectors.joining("\n"));
            this.writeResource(env.getFiler(), (XElement)originatingElement, proguardFile, proguardFileContents);
        });
        this.lazyMapKeysByModule.clear();
    }

    private void writeResource(XFiler filer, XElement originatingElement, Path path, String contents) {
        try (OutputStream outputStream = filer.writeResource(path, (List)ImmutableList.of((Object)originatingElement), XFiler.Mode.Isolating);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            writer.write(contents);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getFullyQualifiedEnclosedClassName(ClassName className) {
        return Joiner.on((char)'_').join((Iterable)ImmutableList.builder().add((Object)className.packageName().replace('.', '_')).addAll((Iterable)className.simpleNames()).build());
    }
}

