/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.CaseFormat;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Traverser;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.ModuleKind;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AutoValue_ModuleDescriptor;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.Declaration;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@AutoValue
public abstract class ModuleDescriptor {
    public abstract XTypeElement moduleElement();

    public abstract ImmutableSet<ContributionBinding> bindings();

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    abstract ImmutableSet<DelegateDeclaration> delegateDeclarations();

    abstract ImmutableSet<OptionalBindingDeclaration> optionalDeclarations();

    public abstract ModuleKind kind();

    public abstract boolean isImplicitlyIncluded();

    @Memoized
    public ImmutableSet<Declaration> allBindingDeclarations() {
        return ImmutableSet.builder().addAll(this.bindings()).addAll(this.delegateDeclarations()).addAll(this.multibindingDeclarations()).addAll(this.optionalDeclarations()).addAll(this.subcomponentDeclarations()).build();
    }

    ImmutableSet<Key> allBindingKeys() {
        return (ImmutableSet)this.allBindingDeclarations().stream().map(Declaration::key).collect(DaggerStreams.toImmutableSet());
    }

    @Singleton
    public static final class Factory
    implements ClearableCache {
        private final XProcessingEnv processingEnv;
        private final BindingFactory bindingFactory;
        private final MultibindingDeclaration.Factory multibindingDeclarationFactory;
        private final DelegateDeclaration.Factory bindingDelegateDeclarationFactory;
        private final SubcomponentDeclaration.Factory subcomponentDeclarationFactory;
        private final OptionalBindingDeclaration.Factory optionalBindingDeclarationFactory;
        private final DaggerSuperficialValidation superficialValidation;
        private final Map<XTypeElement, ModuleDescriptor> cache = new HashMap<XTypeElement, ModuleDescriptor>();
        private final Set<XTypeElement> implicitlyIncludedModules = new LinkedHashSet<XTypeElement>();
        private static final ClassName CONTRIBUTES_ANDROID_INJECTOR = ClassName.get((String)"dagger.android", (String)"ContributesAndroidInjector", (String[])new String[0]);

        @Inject
        Factory(XProcessingEnv processingEnv, BindingFactory bindingFactory, MultibindingDeclaration.Factory multibindingDeclarationFactory, DelegateDeclaration.Factory bindingDelegateDeclarationFactory, SubcomponentDeclaration.Factory subcomponentDeclarationFactory, OptionalBindingDeclaration.Factory optionalBindingDeclarationFactory, DaggerSuperficialValidation superficialValidation) {
            this.processingEnv = processingEnv;
            this.bindingFactory = bindingFactory;
            this.multibindingDeclarationFactory = multibindingDeclarationFactory;
            this.bindingDelegateDeclarationFactory = bindingDelegateDeclarationFactory;
            this.subcomponentDeclarationFactory = subcomponentDeclarationFactory;
            this.optionalBindingDeclarationFactory = optionalBindingDeclarationFactory;
            this.superficialValidation = superficialValidation;
        }

        public ModuleDescriptor create(XTypeElement moduleElement) {
            return Util.reentrantComputeIfAbsent(this.cache, moduleElement, this::createUncached);
        }

        public ModuleDescriptor createUncached(XTypeElement moduleElement) {
            ImmutableSet.Builder bindings = ImmutableSet.builder();
            ImmutableSet.Builder delegates = ImmutableSet.builder();
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            ImmutableSet.Builder optionalDeclarations = ImmutableSet.builder();
            XTypeElements.getAllMethods(moduleElement).stream().forEach(moduleMethod -> {
                if (moduleMethod.hasAnnotation(TypeNames.PROVIDES)) {
                    bindings.add((Object)this.bindingFactory.providesMethodBinding((XMethodElement)moduleMethod, moduleElement));
                }
                if (moduleMethod.hasAnnotation(TypeNames.PRODUCES)) {
                    bindings.add((Object)this.bindingFactory.producesMethodBinding((XMethodElement)moduleMethod, moduleElement));
                }
                if (moduleMethod.hasAnnotation(TypeNames.BINDS)) {
                    delegates.add((Object)this.bindingDelegateDeclarationFactory.create((XMethodElement)moduleMethod, moduleElement));
                }
                if (moduleMethod.hasAnnotation(TypeNames.MULTIBINDS)) {
                    multibindingDeclarations.add((Object)this.multibindingDeclarationFactory.forMultibindsMethod((XMethodElement)moduleMethod, moduleElement));
                }
                if (moduleMethod.hasAnnotation(TypeNames.BINDS_OPTIONAL_OF)) {
                    optionalDeclarations.add((Object)this.optionalBindingDeclarationFactory.forMethod((XMethodElement)moduleMethod, moduleElement));
                }
            });
            ((Optional)moduleElement.getEnclosedTypeElements().stream().filter(XTypeElement::isCompanionObject).collect(DaggerCollectors.toOptional())).ifPresent(companionModule -> this.collectCompanionModuleBindings((XTypeElement)companionModule, (ImmutableSet.Builder<ContributionBinding>)bindings));
            return new AutoValue_ModuleDescriptor(moduleElement, (ImmutableSet<ContributionBinding>)bindings.build(), (ImmutableSet<MultibindingDeclaration>)multibindingDeclarations.build(), this.subcomponentDeclarationFactory.forModule(moduleElement), (ImmutableSet<DelegateDeclaration>)delegates.build(), (ImmutableSet<OptionalBindingDeclaration>)optionalDeclarations.build(), ModuleKind.forAnnotatedElement(moduleElement).get(), this.implicitlyIncludedModules.contains(moduleElement));
        }

        private void collectCompanionModuleBindings(XTypeElement companionModule, ImmutableSet.Builder<ContributionBinding> bindings) {
            ImmutableSet bindingElementDescriptors = (ImmutableSet)bindings.build().stream().map(binding -> XElements.asMethod(binding.bindingElement().get()).getJvmDescriptor()).collect(DaggerStreams.toImmutableSet());
            XTypeElements.getAllMethods(companionModule).stream().filter(method -> !method.hasAnnotation(TypeNames.JVM_STATIC)).filter(method -> !bindingElementDescriptors.contains((Object)method.getJvmDescriptor())).forEach(method -> {
                if (method.hasAnnotation(TypeNames.PROVIDES)) {
                    bindings.add((Object)this.bindingFactory.providesMethodBinding((XMethodElement)method, companionModule));
                }
                if (method.hasAnnotation(TypeNames.PRODUCES)) {
                    bindings.add((Object)this.bindingFactory.producesMethodBinding((XMethodElement)method, companionModule));
                }
            });
        }

        ImmutableSet<ModuleDescriptor> transitiveModules(Collection<XTypeElement> modules) {
            return ImmutableSet.copyOf((Iterable)Traverser.forGraph(module -> Collections2.transform(this.includedModules((ModuleDescriptor)module), this::create)).depthFirstPreOrder((Iterable)Collections2.transform(modules, this::create)));
        }

        private ImmutableSet<XTypeElement> includedModules(ModuleDescriptor moduleDescriptor) {
            return ImmutableSet.copyOf(this.collectIncludedModules(new LinkedHashSet<XTypeElement>(), moduleDescriptor.moduleElement()));
        }

        private Set<XTypeElement> collectIncludedModules(Set<XTypeElement> includedModules, XTypeElement moduleElement) {
            XType superclass = moduleElement.getSuperType();
            if (superclass != null) {
                Verify.verify((boolean)XTypes.isDeclared(superclass));
                if (!TypeName.OBJECT.equals((Object)superclass.getTypeName())) {
                    this.collectIncludedModules(includedModules, superclass.getTypeElement());
                }
            }
            ModuleAnnotation.moduleAnnotation((XElement)moduleElement, this.superficialValidation).ifPresent(moduleAnnotation -> {
                includedModules.addAll((Collection<XTypeElement>)moduleAnnotation.includes());
                ImmutableSet<XTypeElement> daggerAndroidModules = this.implicitlyIncludedModules(moduleElement);
                includedModules.addAll((Collection<XTypeElement>)daggerAndroidModules);
                this.implicitlyIncludedModules.addAll((Collection<XTypeElement>)daggerAndroidModules);
            });
            return includedModules;
        }

        private ImmutableSet<XTypeElement> implicitlyIncludedModules(XTypeElement module) {
            if (this.processingEnv.findTypeElement((TypeName)CONTRIBUTES_ANDROID_INJECTOR) == null) {
                return ImmutableSet.of();
            }
            return (ImmutableSet)module.getDeclaredMethods().stream().filter(method -> method.hasAnnotation(CONTRIBUTES_ANDROID_INJECTOR)).map(method -> DaggerSuperficialValidation.requireTypeElement(this.processingEnv, this.implicitlyIncludedModuleName(module, (XMethodElement)method))).collect(DaggerStreams.toImmutableSet());
        }

        private ClassName implicitlyIncludedModuleName(XTypeElement module, XMethodElement method) {
            return ClassName.get((String)module.getPackageName(), (String)String.format("%s_%s", SourceFiles.classFileName(module.asClassName()), CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, XElements.getSimpleName((XElement)method))), (String[])new String[0]);
        }

        @Override
        public void clearCache() {
            this.cache.clear();
        }
    }
}

