/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.processing.SymbolProcessorProvider;
import dagger.internal.codegen.DelegateComponentProcessor;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingStep;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.ksp.KspBasicAnnotationProcessor;
import dagger.spi.model.BindingGraphPlugin;
import java.util.Arrays;
import java.util.Optional;

public final class KspComponentProcessor
extends KspBasicAnnotationProcessor {
    private final DelegateComponentProcessor delegate = new DelegateComponentProcessor();
    private final Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;

    private KspComponentProcessor(SymbolProcessorEnvironment symbolProcessorEnvironment, Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins) {
        super(symbolProcessorEnvironment, DelegateComponentProcessor.PROCESSING_ENV_CONFIG);
        this.testingPlugins = testingPlugins;
    }

    public void initialize(XProcessingEnv env) {
        this.delegate.initialize(env, this.testingPlugins, Optional.empty());
    }

    public Iterable<XProcessingStep> processingSteps() {
        return this.delegate.processingSteps();
    }

    public void preRound(XProcessingEnv env, XRoundEnv roundEnv) {
        this.delegate.onProcessingRoundBegin();
    }

    public void postRound(XProcessingEnv env, XRoundEnv roundEnv) {
        this.delegate.postRound(env, roundEnv);
    }

    @AutoService(value={SymbolProcessorProvider.class})
    public static final class Provider
    implements SymbolProcessorProvider {
        private final Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;

        @VisibleForTesting
        public static Provider withTestPlugins(BindingGraphPlugin ... testingPlugins) {
            return Provider.withTestPlugins(Arrays.asList(testingPlugins));
        }

        @VisibleForTesting
        public static Provider withTestPlugins(Iterable<BindingGraphPlugin> testingPlugins) {
            return new Provider(Optional.of(ImmutableSet.copyOf(testingPlugins)));
        }

        public Provider() {
            this(Optional.empty());
        }

        private Provider(Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins) {
            this.testingPlugins = testingPlugins;
        }

        public SymbolProcessor create(SymbolProcessorEnvironment symbolProcessorEnvironment) {
            return new KspComponentProcessor(symbolProcessorEnvironment, this.testingPlugins);
        }
    }
}

