/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.Set;

public final class FrameworkTypes {
    private static final ImmutableSet<ClassName> PROVISION_TYPES = ImmutableSet.of((Object)TypeNames.PROVIDER, (Object)TypeNames.LAZY, (Object)TypeNames.MEMBERS_INJECTOR);
    private static final ImmutableSet<ClassName> PRODUCTION_TYPES = ImmutableSet.of((Object)TypeNames.PRODUCED, (Object)TypeNames.PRODUCER);
    private static final ImmutableSet<ClassName> ALL_FRAMEWORK_TYPES = ImmutableSet.builder().addAll(PROVISION_TYPES).addAll(PRODUCTION_TYPES).build();

    public static boolean isProducerType(XType type) {
        return FrameworkTypes.typeIsOneOf(PRODUCTION_TYPES, type);
    }

    public static boolean isFrameworkType(XType type) {
        return FrameworkTypes.typeIsOneOf(ALL_FRAMEWORK_TYPES, type);
    }

    private static boolean typeIsOneOf(Set<ClassName> classNames, XType type) {
        return classNames.stream().anyMatch(className -> XTypes.isTypeOf((XType)type, (ClassName)className));
    }

    private FrameworkTypes() {
    }
}

