/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.SetBuilder;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.DerivedFromFrameworkInstanceRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.spi.model.DependencyRequest;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Collections;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

final class SetRequestRepresentation
extends RequestRepresentation {
    private final ProvisionBinding binding;
    private final BindingGraph graph;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final DaggerTypes types;
    private final DaggerElements elements;

    @AssistedInject
    SetRequestRepresentation(@Assisted ProvisionBinding binding, BindingGraph graph, ComponentRequestRepresentations componentRequestRepresentations, DaggerTypes types, DaggerElements elements) {
        this.binding = binding;
        this.graph = graph;
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.types = types;
        this.elements = elements;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        boolean isImmutableSetAvailable = this.isImmutableSetAvailable();
        if (isImmutableSetAvailable && this.binding.dependencies().stream().allMatch(this::isSingleValue)) {
            return Expression.create(this.immutableSetType(), CodeBlock.builder().add("$T.", new Object[]{ImmutableSet.class}).add(this.maybeTypeParameter(requestingClass)).add("of($L)", new Object[]{this.binding.dependencies().stream().map(dependency -> this.getContributionExpression((DependencyRequest)dependency, requestingClass)).collect(CodeBlocks.toParametersCodeBlock())}).build());
        }
        switch (this.binding.dependencies().size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"emptySet()", (Object[])new Object[0]));
            }
            case 1: {
                DependencyRequest dependency2 = (DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies());
                CodeBlock contributionExpression = this.getContributionExpression(dependency2, requestingClass);
                if (this.isSingleValue(dependency2)) {
                    return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"singleton($L)", (Object[])new Object[]{contributionExpression}));
                }
                if (!isImmutableSetAvailable) break;
                return Expression.create(this.immutableSetType(), CodeBlock.builder().add("$T.", new Object[]{ImmutableSet.class}).add(this.maybeTypeParameter(requestingClass)).add("copyOf($L)", new Object[]{contributionExpression}).build());
            }
        }
        CodeBlock.Builder instantiation = CodeBlock.builder();
        instantiation.add("$T.", new Object[]{isImmutableSetAvailable ? ImmutableSet.class : SetBuilder.class}).add(this.maybeTypeParameter(requestingClass));
        if (this.isImmutableSetBuilderWithExpectedSizeAvailable()) {
            instantiation.add("builderWithExpectedSize($L)", new Object[]{this.binding.dependencies().size()});
        } else if (isImmutableSetAvailable) {
            instantiation.add("builder()", new Object[0]);
        } else {
            instantiation.add("newSetBuilder($L)", new Object[]{this.binding.dependencies().size()});
        }
        for (DependencyRequest dependency3 : this.binding.dependencies()) {
            String builderMethod = this.isSingleValue(dependency3) ? "add" : "addAll";
            instantiation.add(".$L($L)", new Object[]{builderMethod, this.getContributionExpression(dependency3, requestingClass)});
        }
        instantiation.add(".build()", new Object[0]);
        return Expression.create(isImmutableSetAvailable ? this.immutableSetType() : this.binding.key().type().java(), instantiation.build());
    }

    private DeclaredType immutableSetType() {
        return this.types.getDeclaredType(this.elements.getTypeElement(TypeNames.IMMUTABLE_SET), XConverters.toJavac((XType)SetType.from(this.binding.key()).elementType()));
    }

    private CodeBlock getContributionExpression(DependencyRequest dependency, ClassName requestingClass) {
        RequestRepresentation bindingExpression = this.componentRequestRepresentations.getRequestRepresentation(BindingRequest.bindingRequest(dependency));
        CodeBlock expression = bindingExpression.getDependencyExpression(requestingClass).codeBlock();
        return !this.isSingleValue(dependency) && bindingExpression instanceof DerivedFromFrameworkInstanceRequestRepresentation && !Accessibility.isTypeAccessibleFrom(this.binding.key().type().java(), requestingClass.packageName()) ? CodeBlocks.cast(expression, TypeNames.SET) : expression;
    }

    private Expression collectionsStaticFactoryInvocation(ClassName requestingClass, CodeBlock methodInvocation) {
        return Expression.create(this.binding.key().type().java(), CodeBlock.builder().add("$T.", new Object[]{Collections.class}).add(this.maybeTypeParameter(requestingClass)).add(methodInvocation).build());
    }

    private CodeBlock maybeTypeParameter(ClassName requestingClass) {
        XType elementType = SetType.from(this.binding.key()).elementType();
        return Accessibility.isTypeAccessibleFrom(XConverters.toJavac((XType)elementType), requestingClass.packageName()) ? CodeBlock.of((String)"<$T>", (Object[])new Object[]{elementType.getTypeName()}) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private boolean isSingleValue(DependencyRequest dependency) {
        return this.graph.contributionBinding(dependency.key()).contributionType().equals((Object)ContributionType.SET);
    }

    private boolean isImmutableSetBuilderWithExpectedSizeAvailable() {
        if (this.isImmutableSetAvailable()) {
            return ElementFilter.methodsIn(this.elements.getTypeElement(TypeNames.IMMUTABLE_SET).getEnclosedElements()).stream().anyMatch(method -> method.getSimpleName().contentEquals("builderWithExpectedSize"));
        }
        return false;
    }

    private boolean isImmutableSetAvailable() {
        return this.elements.getTypeElement(TypeNames.IMMUTABLE_SET) != null;
    }

    @AssistedFactory
    static interface Factory {
        public SetRequestRepresentation create(ProvisionBinding var1);
    }
}

