/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public class AnnotationExpression
extends SimpleAnnotationValueVisitor8<CodeBlock, AnnotationValue> {
    private final AnnotationMirror annotation;
    private final ClassName creatorClass;

    AnnotationExpression(AnnotationMirror annotation) {
        this.annotation = annotation;
        this.creatorClass = AnnotationExpression.getAnnotationCreatorClassName(MoreTypes.asTypeElement((TypeMirror)annotation.getAnnotationType()));
    }

    CodeBlock getAnnotationInstanceExpression() {
        return this.getAnnotationInstanceExpression(this.annotation);
    }

    private CodeBlock getAnnotationInstanceExpression(AnnotationMirror annotation) {
        return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{this.creatorClass, AnnotationExpression.createMethodName(MoreElements.asType((Element)annotation.getAnnotationType().asElement())), CodeBlocks.makeParametersCodeBlock(AnnotationMirrors.getAnnotationValuesWithDefaults((AnnotationMirror)annotation).entrySet().stream().map(entry -> this.getValueExpression(((ExecutableElement)entry.getKey()).getReturnType(), (AnnotationValue)entry.getValue())).collect(Collectors.toList()))});
    }

    public static ClassName getAnnotationCreatorClassName(TypeElement annotationType) {
        ClassName annotationTypeName = ClassName.get((TypeElement)annotationType);
        return annotationTypeName.topLevelClassName().peerClass(SourceFiles.classFileName(annotationTypeName) + "Creator");
    }

    public static String createMethodName(TypeElement annotationType) {
        return "create" + annotationType.getSimpleName();
    }

    CodeBlock getValueExpression(TypeMirror valueType, AnnotationValue value) {
        CodeBlock codeBlock = (CodeBlock)this.visit(value, value);
        return valueType.getKind() == TypeKind.ARRAY ? CodeBlock.of((String)"new $T[] $L", (Object[])new Object[]{TypeNames.rawTypeName(MoreTypes.asArray((TypeMirror)valueType).getComponentType()), codeBlock}) : codeBlock;
    }

    @Override
    public CodeBlock visitEnumConstant(VariableElement c, AnnotationValue p) {
        return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{c.getEnclosingElement(), c.getSimpleName()});
    }

    @Override
    public CodeBlock visitAnnotation(AnnotationMirror a, AnnotationValue p) {
        return this.getAnnotationInstanceExpression(a);
    }

    @Override
    public CodeBlock visitType(TypeMirror t, AnnotationValue p) {
        return CodeBlock.of((String)"$T.class", (Object[])new Object[]{t});
    }

    @Override
    public CodeBlock visitString(String s, AnnotationValue p) {
        return CodeBlock.of((String)"$S", (Object[])new Object[]{s});
    }

    @Override
    public CodeBlock visitByte(byte b, AnnotationValue p) {
        return CodeBlock.of((String)"(byte) $L", (Object[])new Object[]{b});
    }

    @Override
    public CodeBlock visitChar(char c, AnnotationValue p) {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{p});
    }

    @Override
    public CodeBlock visitDouble(double d, AnnotationValue p) {
        return CodeBlock.of((String)"$LD", (Object[])new Object[]{d});
    }

    @Override
    public CodeBlock visitFloat(float f, AnnotationValue p) {
        return CodeBlock.of((String)"$LF", (Object[])new Object[]{Float.valueOf(f)});
    }

    @Override
    public CodeBlock visitLong(long i, AnnotationValue p) {
        return CodeBlock.of((String)"$LL", (Object[])new Object[]{i});
    }

    @Override
    public CodeBlock visitShort(short s, AnnotationValue p) {
        return CodeBlock.of((String)"(short) $L", (Object[])new Object[]{s});
    }

    @Override
    protected CodeBlock defaultAction(Object o, AnnotationValue p) {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{o});
    }

    @Override
    public CodeBlock visitArray(List<? extends AnnotationValue> values, AnnotationValue p) {
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        for (AnnotationValue annotationValue : values) {
            codeBlocks.add((Object)((CodeBlock)this.visit(annotationValue, p)));
        }
        return CodeBlock.of((String)"{$L}", (Object[])new Object[]{CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)codeBlocks.build())});
    }
}

