/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingRepresentation;
import dagger.internal.codegen.writing.BindingRepresentations;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.DerivedFromFrameworkInstanceRequestRepresentation;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.ProducerNodeInstanceRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.writing.StaticMemberSelects;
import dagger.internal.codegen.writing.UnscopedFrameworkInstanceCreationExpressionFactory;
import dagger.spi.model.BindingKind;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class ProductionBindingRepresentation
implements BindingRepresentation {
    private final ProductionBinding binding;
    private final DerivedFromFrameworkInstanceRequestRepresentation.Factory derivedFromFrameworkInstanceRequestRepresentationFactory;
    private final RequestRepresentation frameworkInstanceRequestRepresentation;
    private final Map<BindingRequest, RequestRepresentation> requestRepresentations = new HashMap<BindingRequest, RequestRepresentation>();

    @AssistedInject
    ProductionBindingRepresentation(@Assisted ProductionBinding binding, ComponentImplementation componentImplementation, DerivedFromFrameworkInstanceRequestRepresentation.Factory derivedFromFrameworkInstanceRequestRepresentationFactory, ProducerNodeInstanceRequestRepresentation.Factory producerNodeInstanceRequestRepresentationFactory, UnscopedFrameworkInstanceCreationExpressionFactory unscopedFrameworkInstanceCreationExpressionFactory, DaggerTypes types) {
        this.binding = binding;
        this.derivedFromFrameworkInstanceRequestRepresentationFactory = derivedFromFrameworkInstanceRequestRepresentationFactory;
        Optional<MemberSelect> staticMethod = this.staticFactoryCreation();
        FrameworkInstanceSupplier frameworkInstanceSupplier = staticMethod.isPresent() ? staticMethod::get : new FrameworkFieldInitializer(componentImplementation, binding, binding.scope().isPresent() ? BindingRepresentations.scope(binding, unscopedFrameworkInstanceCreationExpressionFactory.create(binding)) : unscopedFrameworkInstanceCreationExpressionFactory.create(binding));
        this.frameworkInstanceRequestRepresentation = producerNodeInstanceRequestRepresentationFactory.create(binding, frameworkInstanceSupplier);
    }

    @Override
    public RequestRepresentation getRequestRepresentation(BindingRequest request) {
        return Util.reentrantComputeIfAbsent(this.requestRepresentations, request, this::getRequestRepresentationUncached);
    }

    private RequestRepresentation getRequestRepresentationUncached(BindingRequest request) {
        return request.frameworkType().isPresent() ? this.frameworkInstanceRequestRepresentation : this.derivedFromFrameworkInstanceRequestRepresentationFactory.create(this.frameworkInstanceRequestRepresentation, request.requestKind(), FrameworkType.PRODUCER_NODE);
    }

    private Optional<MemberSelect> staticFactoryCreation() {
        if (this.binding.dependencies().isEmpty()) {
            if (this.binding.kind().equals((Object)BindingKind.MULTIBOUND_MAP)) {
                return Optional.of(StaticMemberSelects.emptyMapFactory(this.binding));
            }
            if (this.binding.kind().equals((Object)BindingKind.MULTIBOUND_SET)) {
                return Optional.of(StaticMemberSelects.emptySetFactory(this.binding));
            }
        }
        return Optional.empty();
    }

    @AssistedFactory
    static interface Factory {
        public ProductionBindingRepresentation create(ProductionBinding var1);
    }
}

