/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentProvisionRequestRepresentation;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class DependencyMethodProviderCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final CompilerOptions compilerOptions;
    private final BindingGraph graph;
    private final ContributionBinding binding;

    @AssistedInject
    DependencyMethodProviderCreationExpression(@Assisted ContributionBinding binding, ComponentImplementation componentImplementation, ComponentRequirementExpressions componentRequirementExpressions, CompilerOptions compilerOptions, BindingGraph graph) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.compilerOptions = compilerOptions;
        this.graph = graph;
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock invocation = ComponentProvisionRequestRepresentation.maybeCheckForNull((ProvisionBinding)this.binding, this.compilerOptions, CodeBlock.of((String)"$N.$N()", (Object[])new Object[]{this.dependency().variableName(), this.provisionMethod().getSimpleName()}));
        ClassName dependencyClassName = ClassName.get((TypeElement)this.dependency().typeElement());
        TypeName keyType = TypeName.get((TypeMirror)this.binding.key().type().java());
        MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(keyType).addStatement("return $L", new Object[]{invocation});
        if (this.binding.nullableType().isPresent()) {
            getMethod.addAnnotation(ClassName.get((TypeElement)MoreTypes.asTypeElement(this.binding.nullableType().get())));
        }
        ComponentImplementation.ShardImplementation componentShard = this.shardImplementation.getComponentImplementation().getComponentShard();
        ClassName factoryClassName = componentShard.name().nestedClass(ClassName.get((TypeElement)this.dependency().typeElement()).toString().replace('.', '_') + "_" + this.binding.bindingElement().get().getSimpleName());
        componentShard.addType(ComponentImplementation.TypeSpecKind.COMPONENT_PROVISION_FACTORY, TypeSpec.classBuilder((ClassName)factoryClassName).addSuperinterface((TypeName)TypeNames.providerOf(keyType)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addField((TypeName)dependencyClassName, this.dependency().variableName(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)dependencyClassName, this.dependency().variableName(), new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{this.dependency().variableName()}).build()).addMethod(getMethod.build()).build());
        return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{factoryClassName, this.componentRequirementExpressions.getExpressionDuringInitialization(this.dependency(), this.shardImplementation.name())});
    }

    private ComponentRequirement dependency() {
        return this.graph.componentDescriptor().getDependencyThatDefinesMethod(this.provisionMethod());
    }

    private Element provisionMethod() {
        return this.binding.bindingElement().get();
    }

    @AssistedFactory
    static interface Factory {
        public DependencyMethodProviderCreationExpression create(ContributionBinding var1);
    }
}

