/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AnnotationExpression;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.androidx.room.compiler.processing.XFiler;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public class AnnotationCreatorGenerator
extends SourceFileGenerator<XTypeElement> {
    private static final ClassName AUTO_ANNOTATION = ClassName.get((String)"com.google.auto.value", (String)"AutoAnnotation", (String[])new String[0]);

    @Inject
    AnnotationCreatorGenerator(XFiler filer, DaggerElements elements, SourceVersion sourceVersion) {
        super(filer, elements, sourceVersion);
    }

    @Override
    public Element originatingElement(XTypeElement annotationType) {
        return XConverters.toJavac(annotationType);
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(XTypeElement annotationType) {
        ClassName generatedTypeName = AnnotationExpression.getAnnotationCreatorClassName(XConverters.toJavac(annotationType));
        TypeSpec.Builder annotationCreatorBuilder = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        for (XTypeElement annotationElement : this.annotationsToCreate(annotationType)) {
            annotationCreatorBuilder.addMethod(this.buildCreateMethod(generatedTypeName, annotationElement));
        }
        return ImmutableList.of((Object)annotationCreatorBuilder);
    }

    private MethodSpec buildCreateMethod(ClassName generatedTypeName, XTypeElement annotationElement) {
        String createMethodName = AnnotationExpression.createMethodName(XConverters.toJavac(annotationElement));
        MethodSpec.Builder createMethod = MethodSpec.methodBuilder((String)createMethodName).addAnnotation(AUTO_ANNOTATION).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(annotationElement.getType().getTypeName());
        ImmutableList.Builder parameters2 = ImmutableList.builder();
        for (XMethodElement annotationMember : annotationElement.getDeclaredMethods()) {
            String parameterName = annotationMember.getName();
            TypeName parameterType = annotationMember.getReturnType().getTypeName();
            createMethod.addParameter(parameterType, parameterName, new Modifier[0]);
            parameters2.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{parameterName}));
        }
        ClassName autoAnnotationClass = generatedTypeName.peerClass("AutoAnnotation_" + generatedTypeName.simpleName() + "_" + createMethodName);
        createMethod.addStatement("return new $T($L)", new Object[]{autoAnnotationClass, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)parameters2.build())});
        return createMethod.build();
    }

    protected Set<XTypeElement> annotationsToCreate(XTypeElement annotationElement) {
        return AnnotationCreatorGenerator.nestedAnnotationElements(annotationElement, new LinkedHashSet<XTypeElement>());
    }

    @CanIgnoreReturnValue
    private static Set<XTypeElement> nestedAnnotationElements(XTypeElement annotationElement, Set<XTypeElement> annotationElements) {
        if (annotationElements.add(annotationElement)) {
            for (XMethodElement method : annotationElement.getDeclaredMethods()) {
                XTypeElement returnType2 = method.getReturnType().getTypeElement();
                if (returnType2 == null || !returnType2.isAnnotationClass()) continue;
                AnnotationCreatorGenerator.nestedAnnotationElements(returnType2, annotationElements);
            }
        }
        return annotationElements;
    }
}

