/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableCollection;
import dagger.MembersInjector;
import dagger.assisted.Assisted;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.MembersInjectionValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.RequestKind;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class DependencyRequestValidator {
    private final MembersInjectionValidator membersInjectionValidator;
    private final InjectionAnnotations injectionAnnotations;
    private final KotlinMetadataUtil metadataUtil;
    private final DaggerElements elements;

    @Inject
    DependencyRequestValidator(MembersInjectionValidator membersInjectionValidator, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil, DaggerElements elements) {
        this.membersInjectionValidator = membersInjectionValidator;
        this.injectionAnnotations = injectionAnnotations;
        this.metadataUtil = metadataUtil;
        this.elements = elements;
    }

    void validateDependencyRequest(ValidationReport.Builder report, Element requestElement, TypeMirror requestType) {
        if (MoreElements.isAnnotationPresent(requestElement, Assisted.class)) {
            return;
        }
        if (this.missingQualifierMetadata(requestElement)) {
            report.addError("Unable to read annotations on an injected Kotlin property. The Dagger compiler must also be applied to any project containing @Inject properties.", requestElement);
            return;
        }
        new Validator(report, requestElement, requestType).validate();
    }

    private boolean missingQualifierMetadata(Element requestElement) {
        if (requestElement.getKind() == ElementKind.FIELD && !requestElement.getModifiers().contains((Object)Modifier.STATIC) && this.metadataUtil.hasMetadata(requestElement) && this.metadataUtil.isMissingSyntheticPropertyForAnnotations(MoreElements.asVariable(requestElement))) {
            Optional<TypeElement> membersInjector = Optional.ofNullable(this.elements.getTypeElement(SourceFiles.membersInjectorNameForType(MoreElements.asType(requestElement.getEnclosingElement()))));
            return !membersInjector.isPresent();
        }
        return false;
    }

    void checkNotProducer(ValidationReport.Builder report, VariableElement requestElement) {
        TypeMirror requestType = requestElement.asType();
        if (FrameworkTypes.isProducerType(requestType)) {
            report.addError(String.format("%s may only be injected in @Produces methods", MoreTypes.asTypeElement(requestType).getSimpleName()), requestElement);
        }
    }

    private final class Validator {
        private final ValidationReport.Builder report;
        private final Element requestElement;
        private final TypeMirror requestType;
        private final TypeMirror keyType;
        private final RequestKind requestKind;
        private final ImmutableCollection<? extends AnnotationMirror> qualifiers;

        Validator(ValidationReport.Builder report, Element requestElement, TypeMirror requestType) {
            this.report = report;
            this.requestElement = requestElement;
            this.requestType = requestType;
            this.keyType = RequestKinds.extractKeyType(requestType);
            this.requestKind = RequestKinds.getRequestKind(requestType);
            this.qualifiers = DependencyRequestValidator.this.injectionAnnotations.getQualifiers(requestElement);
        }

        void validate() {
            this.checkQualifiers();
            this.checkType();
        }

        private void checkQualifiers() {
            if (this.qualifiers.size() > 1) {
                for (AnnotationMirror qualifier : this.qualifiers) {
                    this.report.addError("A single dependency request may not use more than one @Qualifier", this.requestElement, qualifier);
                }
            }
        }

        private void checkType() {
            if (this.qualifiers.isEmpty() && this.keyType.getKind() == TypeKind.DECLARED) {
                TypeElement typeElement2 = MoreTypes.asTypeElement(this.keyType);
                if (AssistedInjectionAnnotations.isAssistedInjectionType(typeElement2)) {
                    this.report.addError("Dagger does not support injecting @AssistedInject type, " + this.requestType + ". Did you mean to inject its assisted factory type instead?", this.requestElement);
                }
                if (this.requestKind != RequestKind.INSTANCE && this.requestKind != RequestKind.PROVIDER && AssistedInjectionAnnotations.isAssistedFactoryType(typeElement2)) {
                    this.report.addError("Dagger does not support injecting Lazy<T>, Producer<T>, or Produced<T> when T is an @AssistedFactory-annotated type such as " + this.keyType, this.requestElement);
                }
            }
            if (this.keyType.getKind().equals((Object)TypeKind.WILDCARD)) {
                this.report.addError("Dagger does not support injecting Provider<T>, Lazy<T>, Producer<T>, or Produced<T> when T is a wildcard type such as " + this.keyType, this.requestElement);
            }
            if (MoreTypes.isType(this.keyType) && MoreTypes.isTypeOf(MembersInjector.class, this.keyType)) {
                DeclaredType membersInjectorType = MoreTypes.asDeclared(this.keyType);
                if (membersInjectorType.getTypeArguments().isEmpty()) {
                    this.report.addError("Cannot inject a raw MembersInjector", this.requestElement);
                } else {
                    this.report.addSubreport(DependencyRequestValidator.this.membersInjectionValidator.validateMembersInjectionRequest(this.requestElement, membersInjectorType.getTypeArguments().get(0)));
                }
            }
        }
    }
}

