/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.validation.AnyBindingMethodValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import javax.inject.Inject;

public final class BindingMethodProcessingStep
extends TypeCheckingProcessingStep<XExecutableElement> {
    private final XMessager messager;
    private final AnyBindingMethodValidator anyBindingMethodValidator;

    @Inject
    BindingMethodProcessingStep(XMessager messager2, AnyBindingMethodValidator anyBindingMethodValidator) {
        this.messager = messager2;
        this.anyBindingMethodValidator = anyBindingMethodValidator;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return this.anyBindingMethodValidator.methodAnnotations();
    }

    @Override
    protected void process(XExecutableElement xElement, ImmutableSet<ClassName> annotations2) {
        Preconditions.checkArgument((boolean)this.anyBindingMethodValidator.isBindingMethod(xElement), (String)"%s is not annotated with any of %s", (Object)xElement, this.annotations());
        if (!this.anyBindingMethodValidator.wasAlreadyValidated(xElement)) {
            this.anyBindingMethodValidator.validate(xElement).printMessagesTo(this.messager);
        }
    }
}

