/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.AutoValue_MultibindingDeclaration;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.multibindings.Multibinds;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.Key;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class MultibindingDeclaration
extends BindingDeclaration
implements ContributionType.HasContributionType {
    @Override
    public abstract Key key();

    @Override
    public abstract ContributionType contributionType();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static final class Factory {
        private final DaggerTypes types;
        private final KeyFactory keyFactory;

        @Inject
        Factory(DaggerTypes types, KeyFactory keyFactory) {
            this.types = types;
            this.keyFactory = keyFactory;
        }

        MultibindingDeclaration forMultibindsMethod(ExecutableElement moduleMethod, TypeElement moduleElement) {
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(moduleMethod, Multibinds.class));
            return this.forDeclaredMethod(moduleMethod, MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(moduleElement.asType()), moduleMethod)), moduleElement);
        }

        private MultibindingDeclaration forDeclaredMethod(ExecutableElement method, ExecutableType methodType, TypeElement contributingType) {
            TypeMirror returnType2 = methodType.getReturnType();
            Preconditions.checkArgument((SetType.isSet(returnType2) || MapType.isMap(returnType2) ? 1 : 0) != 0, (String)"%s must return a set or map", (Object)method);
            return new AutoValue_MultibindingDeclaration(Optional.of(method), Optional.of(contributingType), this.keyFactory.forMultibindsMethod(methodType, method), this.contributionType(returnType2));
        }

        private ContributionType contributionType(TypeMirror returnType2) {
            if (MapType.isMap(returnType2)) {
                return ContributionType.MAP;
            }
            if (SetType.isSet(returnType2)) {
                return ContributionType.SET;
            }
            throw new IllegalArgumentException("Must be Map or Set: " + returnType2);
        }
    }
}

