/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.AutoValue_ModuleAnnotation;
import dagger.internal.codegen.base.MoreAnnotationValues;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoValue
public abstract class ModuleAnnotation {
    private static final ImmutableSet<ClassName> MODULE_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.MODULE, (Object)TypeNames.PRODUCER_MODULE);

    public abstract AnnotationMirror annotation();

    public String annotationName() {
        return this.annotation().getAnnotationType().asElement().getSimpleName().toString();
    }

    public ImmutableList<TypeElement> includes() {
        return (ImmutableList)this.includesAsAnnotationValues().stream().map(MoreAnnotationValues::asType).map(MoreTypes::asTypeElement).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableList<AnnotationValue> includesAsAnnotationValues() {
        return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(this.annotation(), "includes"));
    }

    public ImmutableList<TypeElement> subcomponents() {
        return (ImmutableList)this.subcomponentsAsAnnotationValues().stream().map(MoreAnnotationValues::asType).map(MoreTypes::asTypeElement).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableList<AnnotationValue> subcomponentsAsAnnotationValues() {
        return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(this.annotation(), "subcomponents"));
    }

    public static boolean isModuleAnnotation(AnnotationMirror annotation) {
        return MODULE_ANNOTATIONS.stream().map(ClassName::canonicalName).anyMatch(MoreTypes.asTypeElement(annotation.getAnnotationType()).getQualifiedName()::contentEquals);
    }

    public static ImmutableSet<ClassName> moduleAnnotations() {
        return MODULE_ANNOTATIONS;
    }

    public static ModuleAnnotation moduleAnnotation(AnnotationMirror annotation) {
        Preconditions.checkArgument((boolean)ModuleAnnotation.isModuleAnnotation(annotation), (String)"%s is not a Module or ProducerModule annotation", (Object)annotation);
        return new AutoValue_ModuleAnnotation(annotation);
    }

    public static Optional<ModuleAnnotation> moduleAnnotation(Element element) {
        return DaggerElements.getAnyAnnotation(element, TypeNames.MODULE, TypeNames.PRODUCER_MODULE).map(ModuleAnnotation::moduleAnnotation);
    }
}

