/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MembersInjectionMethods;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

final class MembersInjectionBindingExpression
extends BindingExpression {
    private final MembersInjectionBinding binding;
    private final MembersInjectionMethods membersInjectionMethods;

    @AssistedInject
    MembersInjectionBindingExpression(@Assisted MembersInjectionBinding binding, MembersInjectionMethods membersInjectionMethods) {
        this.binding = binding;
        this.membersInjectionMethods = membersInjectionMethods;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        throw new UnsupportedOperationException(this.binding.toString());
    }

    @Override
    protected CodeBlock getComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        ExecutableElement methodElement = componentMethod.methodElement();
        ParameterSpec parameter = ParameterSpec.get((VariableElement)((VariableElement)Iterables.getOnlyElement(methodElement.getParameters())));
        if (this.binding.injectionSites().isEmpty()) {
            return methodElement.getReturnType().getKind().equals((Object)TypeKind.VOID) ? CodeBlock.of((String)"", (Object[])new Object[0]) : CodeBlock.of((String)"return $N;", (Object[])new Object[]{parameter});
        }
        ClassName requestingClass = component.name();
        return methodElement.getReturnType().getKind().equals((Object)TypeKind.VOID) ? CodeBlock.of((String)"$L;", (Object[])new Object[]{this.membersInjectionInvocation(parameter, requestingClass).codeBlock()}) : CodeBlock.of((String)"return $L;", (Object[])new Object[]{this.membersInjectionInvocation(parameter, requestingClass).codeBlock()});
    }

    private Expression membersInjectionInvocation(ParameterSpec target, ClassName requestingClass) {
        return this.membersInjectionMethods.getInjectExpression(this.binding.key(), CodeBlock.of((String)"$N", (Object[])new Object[]{target}), requestingClass);
    }

    @AssistedFactory
    static interface Factory {
        public MembersInjectionBindingExpression create(MembersInjectionBinding var1);
    }
}

