/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.DependencyRequestFormatter;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.DiagnosticMessageGenerator;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.ComponentPath;
import dagger.spi.model.DiagnosticReporter;
import dagger.spi.model.Key;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;

final class MissingBindingValidator
implements BindingGraphPlugin {
    private final DaggerTypes types;
    private final InjectBindingRegistry injectBindingRegistry;
    private final DependencyRequestFormatter dependencyRequestFormatter;
    private final DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory;

    @Inject
    MissingBindingValidator(DaggerTypes types, InjectBindingRegistry injectBindingRegistry, DependencyRequestFormatter dependencyRequestFormatter, DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory) {
        this.types = types;
        this.injectBindingRegistry = injectBindingRegistry;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
        this.diagnosticMessageGeneratorFactory = diagnosticMessageGeneratorFactory;
    }

    public String pluginName() {
        return "Dagger/MissingBinding";
    }

    public void visitGraph(BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        if (graph.isFullBindingGraph() || graph.rootComponentNode().isSubcomponent()) {
            return;
        }
        graph.missingBindings().forEach(missingBinding -> this.reportMissingBinding((BindingGraph.MissingBinding)missingBinding, graph, diagnosticReporter));
    }

    private void reportMissingBinding(BindingGraph.MissingBinding missingBinding, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        List<ComponentPath> alternativeComponents = graph.bindings(missingBinding.key()).stream().map(Binding::componentPath).distinct().collect(Collectors.toList());
        if (alternativeComponents.isEmpty()) {
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)missingBinding, this.missingBindingErrorMessage(missingBinding, graph));
        } else {
            diagnosticReporter.reportComponent(Diagnostic.Kind.ERROR, (BindingGraph.ComponentNode)graph.componentNode(missingBinding.componentPath()).get(), this.missingBindingErrorMessage(missingBinding, graph) + this.wrongComponentErrorMessage(missingBinding, alternativeComponents, graph));
        }
    }

    private String missingBindingErrorMessage(BindingGraph.MissingBinding missingBinding, BindingGraph graph) {
        Key key = missingBinding.key();
        StringBuilder errorMessage = new StringBuilder();
        Verify.verify((!key.type().java().getKind().equals((Object)TypeKind.WILDCARD) ? 1 : 0) != 0, (String)"unexpected wildcard request: %s", (Object)key);
        errorMessage.append(key).append(" cannot be provided without ");
        if (Keys.isValidImplicitProvisionKey(key, this.types)) {
            errorMessage.append("an @Inject constructor or ");
        }
        errorMessage.append("an @Provides-");
        if (this.allIncomingDependenciesCanUseProduction(missingBinding, graph)) {
            errorMessage.append(" or @Produces-");
        }
        errorMessage.append("annotated method.");
        if (Keys.isValidMembersInjectionKey(key) && this.typeHasInjectionSites(key)) {
            errorMessage.append(" This type supports members injection but cannot be implicitly provided.");
        }
        return errorMessage.toString();
    }

    private String wrongComponentErrorMessage(BindingGraph.MissingBinding missingBinding, List<ComponentPath> alternativeComponentPath, BindingGraph graph) {
        ImmutableSet entryPoints = graph.entryPointEdgesDependingOnBinding((BindingGraph.MaybeBinding)missingBinding);
        DiagnosticMessageGenerator generator = this.diagnosticMessageGeneratorFactory.create(graph);
        ImmutableList<BindingGraph.DependencyEdge> dependencyTrace = generator.dependencyTrace((BindingGraph.MaybeBinding)missingBinding, (ImmutableSet<BindingGraph.DependencyEdge>)entryPoints);
        StringBuilder message = graph.isFullBindingGraph() ? new StringBuilder() : new StringBuilder(dependencyTrace.size() * 100);
        String missingComponentName = MissingBindingValidator.getComponentFromDependencyEdge((BindingGraph.DependencyEdge)dependencyTrace.get(0), graph, false);
        boolean hasSameComponentName = false;
        for (ComponentPath component : alternativeComponentPath) {
            message.append("\nA binding for ").append(missingBinding.key()).append(" exists in ");
            String currentComponentName = component.currentComponent().className().canonicalName();
            if (currentComponentName.contentEquals(missingComponentName)) {
                hasSameComponentName = true;
                message.append("[").append(component).append("]");
            } else {
                message.append(currentComponentName);
            }
            message.append(":");
        }
        for (BindingGraph.DependencyEdge edge : dependencyTrace) {
            String line = this.dependencyRequestFormatter.format(edge.dependencyRequest());
            if (line.isEmpty()) continue;
            String componentName = String.format("[%s] ", MissingBindingValidator.getComponentFromDependencyEdge(edge, graph, hasSameComponentName));
            hasSameComponentName = false;
            message.append("\n").append(line.replace("        ", "        " + componentName));
        }
        if (!dependencyTrace.isEmpty()) {
            generator.appendComponentPathUnlessAtRoot(message, this.source((BindingGraph.Edge)Iterables.getLast(dependencyTrace), graph));
        }
        message.append(generator.getRequestsNotInTrace(dependencyTrace, generator.requests((BindingGraph.MaybeBinding)missingBinding), (ImmutableSet<BindingGraph.DependencyEdge>)entryPoints));
        return message.toString();
    }

    private boolean allIncomingDependenciesCanUseProduction(BindingGraph.MissingBinding missingBinding, BindingGraph graph) {
        return graph.network().inEdges((Object)missingBinding).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).allMatch(edge -> this.dependencyCanBeProduction((BindingGraph.DependencyEdge)edge, graph));
    }

    private boolean dependencyCanBeProduction(BindingGraph.DependencyEdge edge, BindingGraph graph) {
        BindingGraph.Node source = (BindingGraph.Node)graph.network().incidentNodes((Object)edge).source();
        if (source instanceof BindingGraph.ComponentNode) {
            return RequestKinds.canBeSatisfiedByProductionBinding(edge.dependencyRequest().kind());
        }
        if (source instanceof Binding) {
            return ((Binding)source).isProduction();
        }
        throw new IllegalArgumentException("expected a dagger.spi.model.Binding or ComponentNode: " + source);
    }

    private boolean typeHasInjectionSites(Key key) {
        return this.injectBindingRegistry.getOrFindMembersInjectionBinding(key).map(binding -> !binding.injectionSites().isEmpty()).orElse(false);
    }

    private static String getComponentFromDependencyEdge(BindingGraph.DependencyEdge edge, BindingGraph graph, boolean completePath) {
        ComponentPath componentPath = ((BindingGraph.Node)graph.network().incidentNodes((Object)edge).source()).componentPath();
        return completePath ? componentPath.toString() : componentPath.currentComponent().className().canonicalName();
    }

    private BindingGraph.Node source(BindingGraph.Edge edge, BindingGraph graph) {
        return (BindingGraph.Node)graph.network().incidentNodes((Object)edge).source();
    }
}

