/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.DaggerGenerated;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.auto.common.GeneratedAnnotations;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public abstract class SourceFileGenerator<T> {
    private static final String GENERATED_COMMENTS = "https://dagger.dev";
    private final Filer filer;
    private final DaggerElements elements;
    private final SourceVersion sourceVersion;

    public SourceFileGenerator(Filer filer, DaggerElements elements, SourceVersion sourceVersion) {
        this.filer = (Filer)Preconditions.checkNotNull((Object)filer);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
        this.sourceVersion = (SourceVersion)((Object)Preconditions.checkNotNull((Object)((Object)sourceVersion)));
    }

    public SourceFileGenerator(SourceFileGenerator<T> delegate) {
        this(delegate.filer, delegate.elements, delegate.sourceVersion);
    }

    public void generate(T input, Messager messager2) {
        try {
            this.generate(input);
        }
        catch (SourceFileGenerationException e) {
            e.printMessageTo(messager2);
        }
    }

    public void generate(T input) throws SourceFileGenerationException {
        for (TypeSpec.Builder type2 : this.topLevelTypes(input)) {
            try {
                this.buildJavaFile(input, type2).writeTo(this.filer);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, SourceFileGenerationException.class);
                throw new SourceFileGenerationException(Optional.empty(), e, this.originatingElement(input));
            }
        }
    }

    private JavaFile buildJavaFile(T input, TypeSpec.Builder typeSpecBuilder) {
        typeSpecBuilder.addOriginatingElement(this.originatingElement(input));
        typeSpecBuilder.addAnnotation(DaggerGenerated.class);
        Optional<AnnotationSpec> generatedAnnotation = GeneratedAnnotations.generatedAnnotation(this.elements, this.sourceVersion).map(annotation -> AnnotationSpec.builder((ClassName)ClassName.get((TypeElement)annotation)).addMember("value", "$S", new Object[]{"dagger.internal.codegen.ComponentProcessor"}).addMember("comments", "$S", new Object[]{GENERATED_COMMENTS}).build());
        generatedAnnotation.ifPresent(arg_0 -> ((TypeSpec.Builder)typeSpecBuilder).addAnnotation(arg_0));
        typeSpecBuilder.addAnnotation(AnnotationSpecs.suppressWarnings((ImmutableSet<AnnotationSpecs.Suppression>)ImmutableSet.builder().addAll(this.warningSuppressions()).add((Object[])new AnnotationSpecs.Suppression[]{AnnotationSpecs.Suppression.UNCHECKED, AnnotationSpecs.Suppression.RAWTYPES}).build()));
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.elements.getPackageOf(this.originatingElement(input)).getQualifiedName().toString(), (TypeSpec)typeSpecBuilder.build()).skipJavaLangImports(true);
        if (!generatedAnnotation.isPresent()) {
            javaFileBuilder.addFileComment("Generated by Dagger ($L).", new Object[]{GENERATED_COMMENTS});
        }
        return javaFileBuilder.build();
    }

    public abstract Element originatingElement(T var1);

    public abstract ImmutableList<TypeSpec.Builder> topLevelTypes(T var1);

    protected ImmutableSet<AnnotationSpecs.Suppression> warningSuppressions() {
        return ImmutableSet.of();
    }
}

