/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.AutoValue_OptionalType;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.Key;
import java.util.Optional;
import javax.lang.model.element.Name;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;

@AutoValue
public abstract class OptionalType {
    private static final TypeVisitor<Optional<OptionalKind>, Void> OPTIONAL_KIND = new SimpleTypeVisitor8<Optional<OptionalKind>, Void>(Optional.empty()){

        @Override
        public Optional<OptionalKind> visitDeclared(DeclaredType t, Void p) {
            for (OptionalKind optionalKind : OptionalKind.values()) {
                Name qualifiedName2 = MoreElements.asType(t.asElement()).getQualifiedName();
                if (!qualifiedName2.contentEquals(optionalKind.clazz.getCanonicalName())) continue;
                return Optional.of(optionalKind);
            }
            return Optional.empty();
        }
    };

    @Deprecated
    protected abstract Equivalence.Wrapper<DeclaredType> wrappedDeclaredOptionalType();

    private DeclaredType declaredOptionalType() {
        return (DeclaredType)this.wrappedDeclaredOptionalType().get();
    }

    public OptionalKind kind() {
        return this.declaredOptionalType().accept(OPTIONAL_KIND, null).get();
    }

    public TypeMirror valueType() {
        return this.declaredOptionalType().getTypeArguments().get(0);
    }

    private static boolean isOptional(TypeMirror type2) {
        return type2.accept(OPTIONAL_KIND, null).isPresent();
    }

    public static boolean isOptional(Key key) {
        return OptionalType.isOptional(key.type().java());
    }

    public static OptionalType from(TypeMirror type2) {
        Preconditions.checkArgument((boolean)OptionalType.isOptional(type2), (String)"%s must be an Optional", (Object)type2);
        return new AutoValue_OptionalType((Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)MoreTypes.asDeclared(type2)));
    }

    public static OptionalType from(Key key) {
        return OptionalType.from(key.type().java());
    }

    public static enum OptionalKind {
        GUAVA_OPTIONAL(com.google.common.base.Optional.class, "absent"),
        JDK_OPTIONAL(Optional.class, "empty");

        private final Class<?> clazz;
        private final String absentFactoryMethodName;

        private OptionalKind(Class<?> clazz, String absentFactoryMethodName) {
            this.clazz = clazz;
            this.absentFactoryMethodName = absentFactoryMethodName;
        }

        public ParameterizedTypeName of(TypeName valueType) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(this.clazz), (TypeName[])new TypeName[]{valueType});
        }

        public CodeBlock absentValueExpression() {
            return CodeBlock.of((String)"$T.$L()", (Object[])new Object[]{this.clazz, this.absentFactoryMethodName});
        }

        public CodeBlock parameterizedAbsentValueExpression(OptionalType optionalType) {
            return CodeBlock.of((String)"$T.<$T>$L()", (Object[])new Object[]{this.clazz, optionalType.valueType(), this.absentFactoryMethodName});
        }

        public CodeBlock presentExpression(CodeBlock value2) {
            return CodeBlock.of((String)"$T.of($L)", (Object[])new Object[]{this.clazz, value2});
        }

        public CodeBlock presentObjectExpression(CodeBlock value2) {
            return CodeBlock.of((String)"$T.<$T>of($L)", (Object[])new Object[]{this.clazz, Object.class, value2});
        }
    }
}

