/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.statistics;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import dagger.internal.codegen.statistics.DaggerStatistics;
import dagger.internal.codegen.statistics.DaggerStatisticsRecorder;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class DaggerStatisticsCollector {
    private final Ticker ticker;
    private final Stopwatch totalRuntimeStopwatch;
    private final Map<BasicAnnotationProcessor.ProcessingStep, Stopwatch> stepStopwatches = new HashMap<BasicAnnotationProcessor.ProcessingStep, Stopwatch>();
    private final DaggerStatistics.Builder statisticsBuilder = DaggerStatistics.builder();
    private DaggerStatistics.RoundStatistics.Builder roundBuilder = DaggerStatistics.roundBuilder();
    private final Optional<DaggerStatisticsRecorder> statisticsRecorder;
    private int injectFactoriesGenerated;
    private int membersInjectorsGenerated;

    @Inject
    DaggerStatisticsCollector(Ticker ticker, Optional<DaggerStatisticsRecorder> statisticsRecorder) {
        this.ticker = ticker;
        this.totalRuntimeStopwatch = Stopwatch.createUnstarted((Ticker)ticker);
        this.statisticsRecorder = statisticsRecorder;
    }

    public void processingStarted() {
        Preconditions.checkState((!this.totalRuntimeStopwatch.isRunning() ? 1 : 0) != 0);
        this.totalRuntimeStopwatch.start();
    }

    void stepStarted(BasicAnnotationProcessor.ProcessingStep step) {
        Stopwatch stopwatch = this.stepStopwatches.computeIfAbsent(step, unused -> Stopwatch.createUnstarted((Ticker)this.ticker));
        stopwatch.start();
    }

    void stepFinished(BasicAnnotationProcessor.ProcessingStep step) {
        Stopwatch stopwatch = this.stepStopwatches.get(step);
        this.roundBuilder.addStepDuration(step, this.elapsedTime(stopwatch));
        stopwatch.reset();
    }

    public void roundFinished() {
        this.statisticsBuilder.addRound(this.roundBuilder.build());
        this.roundBuilder = DaggerStatistics.roundBuilder();
    }

    public void processingStopped() {
        Preconditions.checkState((boolean)this.totalRuntimeStopwatch.isRunning());
        this.totalRuntimeStopwatch.stop();
        this.statisticsBuilder.setTotalProcessingTime(this.elapsedTime(this.totalRuntimeStopwatch)).setInjectFactoriesGenerated(this.injectFactoriesGenerated).setMembersInjectorsGenerated(this.membersInjectorsGenerated);
        this.statisticsRecorder.ifPresent(recorder -> recorder.recordStatistics(this.statisticsBuilder.build()));
    }

    public void recordInjectFactoryGenerated() {
        ++this.injectFactoriesGenerated;
    }

    public void recordMembersInjectorGenerated() {
        ++this.membersInjectorsGenerated;
    }

    private Duration elapsedTime(Stopwatch stopwatch) {
        return Duration.ofNanos(stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }
}

