/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.ComponentNodeImpl;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Util;
import dagger.model.BindingGraph;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.tools.Diagnostic;

final class SubcomponentFactoryMethodValidator
implements BindingGraphPlugin {
    private final DaggerTypes types;
    private final Map<BindingGraph.ComponentNode, Set<TypeElement>> inheritedModulesCache = new HashMap<BindingGraph.ComponentNode, Set<TypeElement>>();

    @Inject
    SubcomponentFactoryMethodValidator(DaggerTypes types) {
        this.types = types;
    }

    public String pluginName() {
        return "Dagger/SubcomponentFactoryMethodMissingModule";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        if (!bindingGraph.rootComponentNode().isRealComponent() || bindingGraph.rootComponentNode().isSubcomponent()) {
            return;
        }
        bindingGraph.network().edges().stream().flatMap(DaggerStreams.instancesOf(BindingGraph.ChildFactoryMethodEdge.class)).forEach(edge -> {
            ImmutableSet<TypeElement> missingModules = this.findMissingModules((BindingGraph.ChildFactoryMethodEdge)edge, bindingGraph);
            if (!missingModules.isEmpty()) {
                this.reportMissingModuleParameters((BindingGraph.ChildFactoryMethodEdge)edge, missingModules, bindingGraph, diagnosticReporter);
            }
        });
    }

    private ImmutableSet<TypeElement> findMissingModules(BindingGraph.ChildFactoryMethodEdge edge, BindingGraph graph) {
        ImmutableSet<TypeElement> factoryMethodParameters = this.subgraphFactoryMethodParameters(edge, graph);
        BindingGraph.ComponentNode child = (BindingGraph.ComponentNode)graph.network().incidentNodes((Object)edge).target();
        Sets.SetView<TypeElement> modulesOwnedByChild = this.ownedModules(child, graph);
        return graph.bindings().stream().filter(binding -> binding.componentPath().equals((Object)child.componentPath())).filter(binding -> binding.requiresModuleInstance()).map(binding -> (TypeElement)binding.contributingModule().get()).distinct().filter(module -> modulesOwnedByChild.contains(module)).filter(module -> !factoryMethodParameters.contains(module)).filter(moduleType -> !Util.componentCanMakeNewInstances(moduleType)).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableSet<TypeElement> subgraphFactoryMethodParameters(BindingGraph.ChildFactoryMethodEdge edge, BindingGraph bindingGraph) {
        BindingGraph.ComponentNode parent = (BindingGraph.ComponentNode)bindingGraph.network().incidentNodes((Object)edge).source();
        DeclaredType parentType = MoreTypes.asDeclared(parent.componentPath().currentComponent().asType());
        ExecutableType factoryMethodType = MoreTypes.asExecutable(this.types.asMemberOf(parentType, edge.factoryMethod()));
        return MoreTypes.asTypeElements(factoryMethodType.getParameterTypes());
    }

    private Sets.SetView<TypeElement> ownedModules(BindingGraph.ComponentNode component, BindingGraph graph) {
        return Sets.difference(((ComponentNodeImpl)component).componentDescriptor().moduleTypes(), this.inheritedModules(component, graph));
    }

    private Set<TypeElement> inheritedModules(BindingGraph.ComponentNode component, BindingGraph graph) {
        return Util.reentrantComputeIfAbsent(this.inheritedModulesCache, component, this.uncachedInheritedModules(graph));
    }

    private Function<BindingGraph.ComponentNode, Set<TypeElement>> uncachedInheritedModules(BindingGraph graph) {
        return componentNode -> componentNode.componentPath().atRoot() ? ImmutableSet.of() : (Set)graph.componentNode(componentNode.componentPath().parent()).map(parent -> Sets.union(this.ownedModules((BindingGraph.ComponentNode)parent, graph), this.inheritedModules((BindingGraph.ComponentNode)parent, graph))).get();
    }

    private void reportMissingModuleParameters(BindingGraph.ChildFactoryMethodEdge edge, ImmutableSet<TypeElement> missingModules, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        diagnosticReporter.reportSubcomponentFactoryMethod(Diagnostic.Kind.ERROR, edge, "%s requires modules which have no visible default constructors. Add the following modules as parameters to this method: %s", (Object)((BindingGraph.Node)graph.network().incidentNodes((Object)edge).target()).componentPath().currentComponent().getQualifiedName(), new Object[]{Joiner.on((String)", ").join(missingModules)});
    }
}

