/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ProvisionBinding;
import dagger.model.Key;
import java.util.Optional;

abstract class MultibindingFactoryCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ComponentImplementation componentImplementation;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final ContributionBinding binding;

    MultibindingFactoryCreationExpression(ContributionBinding binding, ComponentImplementation componentImplementation, ComponentBindingExpressions componentBindingExpressions) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
    }

    protected final CodeBlock multibindingDependencyExpression(FrameworkDependency frameworkDependency) {
        CodeBlock expression = this.componentBindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(frameworkDependency), this.componentImplementation.name()).codeBlock();
        return this.useRawType() ? CodeBlocks.cast(expression, frameworkDependency.frameworkClass()) : expression;
    }

    protected final ImmutableSet<FrameworkDependency> frameworkDependenciesToImplement() {
        ImmutableSet<Key> alreadyImplementedKeys = this.componentImplementation.superclassContributionsMade(this.bindingRequest());
        return this.binding.frameworkDependencies().stream().filter(frameworkDependency -> !alreadyImplementedKeys.contains((Object)frameworkDependency.key())).collect(DaggerStreams.toImmutableSet());
    }

    protected Optional<CodeBlock> superContributions() {
        if (this.frameworkDependenciesToImplement().size() == this.binding.frameworkDependencies().size()) {
            return Optional.empty();
        }
        ModifiableBindingMethods.ModifiableBindingMethod superMethod = this.componentImplementation.getModifiableBindingMethod(this.bindingRequest()).get();
        return Optional.of(CodeBlock.of((String)"super.$N()", (Object[])new Object[]{superMethod.methodSpec().name}));
    }

    protected final BindingRequest bindingRequest() {
        return BindingRequest.bindingRequest(this.binding.key(), this.binding instanceof ProvisionBinding ? FrameworkType.PROVIDER : FrameworkType.PRODUCER_NODE);
    }

    protected final boolean useRawType() {
        return !this.componentImplementation.isTypeAccessible(this.binding.key().type());
    }

    @Override
    public final boolean useInnerSwitchingProvider() {
        return !this.binding.dependencies().isEmpty();
    }
}

