/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import dagger.Subcomponent;
import dagger.internal.codegen.AnyBindingMethodValidator;
import dagger.internal.codegen.BindingGraphConverter;
import dagger.internal.codegen.BindingGraphFactory;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentAnnotation;
import dagger.internal.codegen.ComponentCreatorAnnotation;
import dagger.internal.codegen.ComponentDescriptorFactory;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ModuleAnnotation;
import dagger.internal.codegen.ModuleKind;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.MoreAnnotationValues;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.ValidationType;
import dagger.model.BindingGraph;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.shaded.auto.common.Visibility;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;

@Singleton
final class ModuleValidator {
    private static final ImmutableSet<Class<? extends Annotation>> SUBCOMPONENT_TYPES;
    private static final ImmutableSet<Class<? extends Annotation>> SUBCOMPONENT_CREATOR_TYPES;
    private static final Optional<Class<?>> ANDROID_PROCESSOR;
    private static final String CONTRIBUTES_ANDROID_INJECTOR_NAME = "dagger.android.ContributesAndroidInjector";
    private static final String ANDROID_PROCESSOR_NAME = "dagger.android.processor.AndroidProcessor";
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final AnyBindingMethodValidator anyBindingMethodValidator;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final ComponentDescriptorFactory componentDescriptorFactory;
    private final BindingGraphFactory bindingGraphFactory;
    private final BindingGraphConverter bindingGraphConverter;
    private final BindingGraphValidator bindingGraphValidator;
    private final CompilerOptions compilerOptions;
    private final Map<TypeElement, ValidationReport<TypeElement>> cache = new HashMap<TypeElement, ValidationReport<TypeElement>>();
    private final Set<TypeElement> knownModules = new HashSet<TypeElement>();

    @Inject
    ModuleValidator(DaggerTypes types, DaggerElements elements, AnyBindingMethodValidator anyBindingMethodValidator, MethodSignatureFormatter methodSignatureFormatter, ComponentDescriptorFactory componentDescriptorFactory, BindingGraphFactory bindingGraphFactory, BindingGraphConverter bindingGraphConverter, BindingGraphValidator bindingGraphValidator, CompilerOptions compilerOptions) {
        this.types = types;
        this.elements = elements;
        this.anyBindingMethodValidator = anyBindingMethodValidator;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.bindingGraphConverter = bindingGraphConverter;
        this.bindingGraphValidator = bindingGraphValidator;
        this.compilerOptions = compilerOptions;
    }

    void addKnownModules(Collection<TypeElement> modules) {
        this.knownModules.addAll(modules);
    }

    ValidationReport<TypeElement> validate(TypeElement module) {
        return this.validate(module, new HashSet<TypeElement>());
    }

    private ValidationReport<TypeElement> validate(TypeElement module, Set<TypeElement> visitedModules) {
        if (visitedModules.add(module)) {
            return Util.reentrantComputeIfAbsent(this.cache, module, m -> this.validateUncached(module, visitedModules));
        }
        return ValidationReport.about(module).build();
    }

    private ValidationReport<TypeElement> validateUncached(TypeElement module, Set<TypeElement> visitedModules) {
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(module);
        ModuleKind moduleKind = ModuleKind.forAnnotatedElement(module).get();
        ArrayListMultimap allMethodsByName = ArrayListMultimap.create();
        ArrayListMultimap bindingMethodsByName = ArrayListMultimap.create();
        EnumSet<ModuleMethodKind> methodKinds = EnumSet.noneOf(ModuleMethodKind.class);
        TypeElement contributesAndroidInjectorElement = this.elements.getTypeElement(CONTRIBUTES_ANDROID_INJECTOR_NAME);
        TypeMirror contributesAndroidInjector = contributesAndroidInjectorElement != null ? contributesAndroidInjectorElement.asType() : null;
        block0: for (ExecutableElement moduleMethod : ElementFilter.methodsIn(module.getEnclosedElements())) {
            if (this.anyBindingMethodValidator.isBindingMethod(moduleMethod)) {
                builder.addSubreport(this.anyBindingMethodValidator.validate(moduleMethod));
                bindingMethodsByName.put((Object)moduleMethod.getSimpleName().toString(), (Object)moduleMethod);
                methodKinds.add(ModuleMethodKind.ofMethod(moduleMethod));
            }
            allMethodsByName.put((Object)moduleMethod.getSimpleName().toString(), (Object)moduleMethod);
            for (AnnotationMirror annotationMirror : moduleMethod.getAnnotationMirrors()) {
                if (ANDROID_PROCESSOR.isPresent() || !MoreTypes.equivalence().equivalent((Object)contributesAndroidInjector, (Object)annotationMirror.getAnnotationType())) continue;
                builder.addSubreport(ValidationReport.about(moduleMethod).addError(String.format("@%s was used, but %s was not found on the processor path", CONTRIBUTES_ANDROID_INJECTOR_NAME, ANDROID_PROCESSOR_NAME)).build());
                continue block0;
            }
        }
        if (methodKinds.containsAll(EnumSet.of(ModuleMethodKind.ABSTRACT_DECLARATION, ModuleMethodKind.INSTANCE_BINDING))) {
            builder.addError(String.format("A @%s may not contain both non-static and abstract binding methods", moduleKind.annotation().getSimpleName()));
        }
        this.validateModuleVisibility(module, moduleKind, builder);
        this.validateMethodsWithSameName(builder, (ListMultimap<String, ExecutableElement>)bindingMethodsByName);
        if (module.getKind() != ElementKind.INTERFACE) {
            this.validateBindingMethodOverrides(module, builder, (ListMultimap<String, ExecutableElement>)allMethodsByName, (ListMultimap<String, ExecutableElement>)bindingMethodsByName);
        }
        this.validateModifiers(module, builder);
        this.validateReferencedModules(module, moduleKind, visitedModules, builder);
        this.validateReferencedSubcomponents(module, moduleKind, builder);
        this.validateNoScopeAnnotationsOnModuleElement(module, moduleKind, builder);
        this.validateSelfCycles(module, builder);
        if (builder.build().isClean() && !this.compilerOptions.moduleBindingValidationType().equals((Object)ValidationType.NONE)) {
            this.validateModuleBindings(module, builder);
        }
        return builder.build();
    }

    private void validateReferencedSubcomponents(final TypeElement subject, ModuleKind moduleKind, final ValidationReport.Builder<TypeElement> builder) {
        final ModuleAnnotation moduleAnnotation = ModuleAnnotation.moduleAnnotation(moduleKind.getModuleAnnotation(subject));
        for (final AnnotationValue subcomponentAttribute : moduleAnnotation.subcomponentsAsAnnotationValues()) {
            MoreAnnotationValues.asType(subcomponentAttribute).accept(new SimpleTypeVisitor8<Void, Void>(){

                @Override
                protected Void defaultAction(TypeMirror e, Void aVoid) {
                    builder.addError(e + " is not a valid subcomponent type", subject, moduleAnnotation.annotation(), subcomponentAttribute);
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType declaredType, Void aVoid) {
                    TypeElement attributeType = MoreTypes.asTypeElement(declaredType);
                    if (DaggerElements.isAnyAnnotationPresent(attributeType, (Iterable<? extends Class<? extends Annotation>>)SUBCOMPONENT_TYPES)) {
                        ModuleValidator.validateSubcomponentHasBuilder(attributeType, moduleAnnotation.annotation(), builder);
                    } else {
                        builder.addError(DaggerElements.isAnyAnnotationPresent(attributeType, (Iterable<? extends Class<? extends Annotation>>)SUBCOMPONENT_CREATOR_TYPES) ? ModuleValidator.moduleSubcomponentsIncludesCreator(attributeType) : ModuleValidator.moduleSubcomponentsIncludesNonSubcomponent(attributeType), subject, moduleAnnotation.annotation(), subcomponentAttribute);
                    }
                    return null;
                }
            }, null);
        }
    }

    private static String moduleSubcomponentsIncludesNonSubcomponent(TypeElement notSubcomponent) {
        return notSubcomponent.getQualifiedName() + " is not a @Subcomponent or @ProductionSubcomponent";
    }

    private static String moduleSubcomponentsIncludesCreator(TypeElement moduleSubcomponentsAttribute) {
        TypeElement subcomponentType = MoreElements.asType(moduleSubcomponentsAttribute.getEnclosingElement());
        ComponentCreatorAnnotation creatorAnnotation = (ComponentCreatorAnnotation)((Object)Iterables.getOnlyElement(ComponentCreatorAnnotation.getCreatorAnnotations(moduleSubcomponentsAttribute)));
        return String.format("%s is a @%s.%s. Did you mean to use %s?", moduleSubcomponentsAttribute.getQualifiedName(), ComponentAnnotation.subcomponentAnnotation(subcomponentType).get().simpleName(), creatorAnnotation.creatorKind().typeName(), subcomponentType.getQualifiedName());
    }

    private static void validateSubcomponentHasBuilder(TypeElement subcomponentAttribute, AnnotationMirror moduleAnnotation, ValidationReport.Builder<TypeElement> builder) {
        if (ConfigurationAnnotations.getSubcomponentCreator(subcomponentAttribute).isPresent()) {
            return;
        }
        builder.addError(ModuleValidator.moduleSubcomponentsDoesntHaveCreator(subcomponentAttribute, moduleAnnotation), builder.getSubject(), moduleAnnotation);
    }

    private static String moduleSubcomponentsDoesntHaveCreator(TypeElement subcomponent, AnnotationMirror moduleAnnotation) {
        return String.format("%1$s doesn't have a @%2$s.Builder or @%2$s.Factory, which is required when used with @%3$s.subcomponents", subcomponent.getQualifiedName(), ComponentAnnotation.subcomponentAnnotation(subcomponent).get().simpleName(), MoreAnnotationMirrors.simpleName(moduleAnnotation));
    }

    private void validateModifiers(TypeElement subject, ValidationReport.Builder<TypeElement> builder) {
        if (!subject.getTypeParameters().isEmpty() && !subject.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            builder.addError("Modules with type parameters must be abstract", subject);
        }
    }

    private void validateMethodsWithSameName(ValidationReport.Builder<TypeElement> builder, ListMultimap<String, ExecutableElement> bindingMethodsByName) {
        for (Map.Entry entry : bindingMethodsByName.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            for (ExecutableElement offendingMethod : (Collection)entry.getValue()) {
                builder.addError(String.format("Cannot have more than one binding method with the same name in a single module", new Object[0]), offendingMethod);
            }
        }
    }

    private void validateReferencedModules(TypeElement subject, ModuleKind moduleKind, Set<TypeElement> visitedModules, ValidationReport.Builder<TypeElement> builder) {
        AnnotationMirror mirror = moduleKind.getModuleAnnotation(subject);
        builder.addSubreport(this.validateReferencedModules(subject, mirror, moduleKind.legalIncludedModuleKinds(), visitedModules));
    }

    ValidationReport<TypeElement> validateReferencedModules(final TypeElement annotatedType, final AnnotationMirror annotation, ImmutableSet<ModuleKind> validModuleKinds, final Set<TypeElement> visitedModules) {
        final ValidationReport.Builder<TypeElement> subreport = ValidationReport.about(annotatedType);
        final ImmutableSet validModuleAnnotations = validModuleKinds.stream().map(ModuleKind::annotation).collect(DaggerStreams.toImmutableSet());
        for (final AnnotationValue includedModule : ModuleValidator.getModules(annotation)) {
            MoreAnnotationValues.asType(includedModule).accept(new SimpleTypeVisitor8<Void, Void>(){

                @Override
                protected Void defaultAction(TypeMirror mirror, Void p) {
                    this.reportError("%s is not a valid module type.", mirror);
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType t, Void p) {
                    TypeElement module = MoreElements.asType(t.asElement());
                    if (!t.getTypeArguments().isEmpty()) {
                        this.reportError("%s is listed as a module, but has type parameters", module.getQualifiedName());
                    }
                    if (!DaggerElements.isAnyAnnotationPresent(module, (Iterable<? extends Class<? extends Annotation>>)validModuleAnnotations)) {
                        this.reportError("%s is listed as a module, but is not annotated with %s", module.getQualifiedName(), (validModuleAnnotations.size() > 1 ? "one of " : "") + validModuleAnnotations.stream().map(otherClass -> "@" + otherClass.getSimpleName()).collect(Collectors.joining(", ")));
                    } else if (ModuleValidator.this.knownModules.contains(module) && !ModuleValidator.this.validate(module, visitedModules).isClean()) {
                        this.reportError("%s has errors", module.getQualifiedName());
                    }
                    return null;
                }

                private void reportError(String format, Object ... args) {
                    subreport.addError(String.format(format, args), annotatedType, annotation, includedModule);
                }
            }, null);
        }
        return subreport.build();
    }

    private static ImmutableList<AnnotationValue> getModules(AnnotationMirror annotation) {
        if (ModuleAnnotation.isModuleAnnotation(annotation)) {
            return ModuleAnnotation.moduleAnnotation(annotation).includesAsAnnotationValues();
        }
        if (ComponentAnnotation.isComponentAnnotation(annotation)) {
            return ComponentAnnotation.componentAnnotation(annotation).moduleValues();
        }
        throw new IllegalArgumentException(String.format("unsupported annotation: %s", annotation));
    }

    private void validateBindingMethodOverrides(TypeElement subject, ValidationReport.Builder<TypeElement> builder, ListMultimap<String, ExecutableElement> allMethodsByName, ListMultimap<String, ExecutableElement> bindingMethodsByName) {
        TypeElement currentClass = subject;
        TypeMirror objectType = this.elements.getTypeElement(Object.class).asType();
        HashSet failedMethods = Sets.newHashSet();
        while (!this.types.isSameType(currentClass.getSuperclass(), objectType)) {
            currentClass = MoreElements.asType(this.types.asElement(currentClass.getSuperclass()));
            List<ExecutableElement> superclassMethods = ElementFilter.methodsIn(currentClass.getEnclosedElements());
            for (ExecutableElement superclassMethod : superclassMethods) {
                String name = superclassMethod.getSimpleName().toString();
                for (ExecutableElement bindingMethod : bindingMethodsByName.get((Object)name)) {
                    if (!failedMethods.add(bindingMethod) || !this.elements.overrides(bindingMethod, superclassMethod, subject)) continue;
                    builder.addError(String.format("Binding methods may not override another method. Overrides: %s", this.methodSignatureFormatter.format(superclassMethod)), bindingMethod);
                }
                if (this.anyBindingMethodValidator.isBindingMethod(superclassMethod)) {
                    for (ExecutableElement method : allMethodsByName.get((Object)name)) {
                        if (!failedMethods.add(method) || !this.elements.overrides(method, superclassMethod, subject)) continue;
                        builder.addError(String.format("Binding methods may not be overridden in modules. Overrides: %s", this.methodSignatureFormatter.format(superclassMethod)), method);
                    }
                }
                allMethodsByName.put((Object)superclassMethod.getSimpleName().toString(), (Object)superclassMethod);
            }
        }
    }

    private void validateModuleVisibility(TypeElement moduleElement, ModuleKind moduleKind, ValidationReport.Builder<?> reportBuilder) {
        ModuleAnnotation moduleAnnotation = ModuleAnnotation.moduleAnnotation(DaggerElements.getAnnotationMirror(moduleElement, moduleKind.annotation()).get());
        Visibility moduleVisibility = Visibility.ofElement(moduleElement);
        Visibility moduleEffectiveVisibility = Visibility.effectiveVisibilityOfElement(moduleElement);
        if (moduleVisibility.equals((Object)Visibility.PRIVATE)) {
            reportBuilder.addError("Modules cannot be private.", moduleElement);
        } else if (moduleEffectiveVisibility.equals((Object)Visibility.PRIVATE)) {
            reportBuilder.addError("Modules cannot be enclosed in private types.", moduleElement);
        }
        switch (moduleElement.getNestingKind()) {
            case ANONYMOUS: {
                throw new IllegalStateException("Can't apply @Module to an anonymous class");
            }
            case LOCAL: {
                throw new IllegalStateException("Local classes shouldn't show up in the processor");
            }
            case MEMBER: 
            case TOP_LEVEL: {
                ImmutableSet<TypeElement> invalidVisibilityIncludes;
                if (!moduleEffectiveVisibility.equals((Object)Visibility.PUBLIC) || (invalidVisibilityIncludes = this.getModuleIncludesWithInvalidVisibility(moduleAnnotation)).isEmpty()) break;
                reportBuilder.addError(String.format("This module is public, but it includes non-public (or effectively non-public) modules (%s) that have non-static, non-abstract binding methods. Either reduce the visibility of this module, make the included modules public, or make all of the binding methods on the included modules abstract or static.", ModuleValidator.formatListForErrorMessage(invalidVisibilityIncludes.asList())), moduleElement);
            }
        }
    }

    private ImmutableSet<TypeElement> getModuleIncludesWithInvalidVisibility(ModuleAnnotation moduleAnnotation) {
        return moduleAnnotation.includes().stream().filter(include -> !Visibility.effectiveVisibilityOfElement(include).equals((Object)Visibility.PUBLIC)).filter(this::requiresModuleInstance).collect(DaggerStreams.toImmutableSet());
    }

    private boolean requiresModuleInstance(TypeElement module) {
        return ElementFilter.methodsIn(this.elements.getAllMembers(module)).stream().filter(method -> this.anyBindingMethodValidator.isBindingMethod((ExecutableElement)method)).map(Element::getModifiers).anyMatch(modifiers -> !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC));
    }

    private void validateNoScopeAnnotationsOnModuleElement(TypeElement module, ModuleKind moduleKind, ValidationReport.Builder<TypeElement> report) {
        for (AnnotationMirror scope : AnnotationMirrors.getAnnotatedAnnotations(module, Scope.class)) {
            report.addError(String.format("@%ss cannot be scoped. Did you mean to scope a method instead?", moduleKind.annotation().getSimpleName()), module, scope);
        }
    }

    private void validateSelfCycles(final TypeElement module, final ValidationReport.Builder<TypeElement> builder) {
        final ModuleAnnotation moduleAnnotation = ModuleAnnotation.moduleAnnotation(module).get();
        moduleAnnotation.includesAsAnnotationValues().forEach(value -> value.accept(new SimpleAnnotationValueVisitor8<Void, Void>(){

            @Override
            public Void visitType(TypeMirror includedModule, Void aVoid) {
                if (MoreTypes.equivalence().equivalent((Object)module.asType(), (Object)includedModule)) {
                    String moduleKind = moduleAnnotation.annotationClass().getSimpleName();
                    builder.addError(String.format("@%s cannot include themselves.", moduleKind), module, moduleAnnotation.annotation(), value);
                }
                return null;
            }
        }, null));
    }

    private void validateModuleBindings(TypeElement module, ValidationReport.Builder<TypeElement> report) {
        BindingGraph bindingGraph = this.bindingGraphConverter.convert(this.bindingGraphFactory.create(this.componentDescriptorFactory.moduleComponentDescriptor(module), true));
        if (!this.bindingGraphValidator.isValid(bindingGraph)) {
            report.markDirty();
        }
    }

    private static String formatListForErrorMessage(List<?> things) {
        switch (things.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return things.get(0).toString();
            }
        }
        StringBuilder output = new StringBuilder();
        Joiner.on((String)", ").appendTo(output, things.subList(0, things.size() - 1));
        output.append(" and ").append(things.get(things.size() - 1));
        return output.toString();
    }

    static {
        Class<?> clazz;
        SUBCOMPONENT_TYPES = ImmutableSet.of(Subcomponent.class, ProductionSubcomponent.class);
        SUBCOMPONENT_CREATOR_TYPES = ImmutableSet.of(Subcomponent.Builder.class, Subcomponent.Factory.class, ProductionSubcomponent.Builder.class, ProductionSubcomponent.Factory.class);
        try {
            clazz = Class.forName(ANDROID_PROCESSOR_NAME, false, ModuleValidator.class.getClassLoader());
        }
        catch (ClassNotFoundException ignored) {
            clazz = null;
        }
        ANDROID_PROCESSOR = Optional.ofNullable(clazz);
    }

    static enum ModuleMethodKind {
        ABSTRACT_DECLARATION,
        INSTANCE_BINDING,
        STATIC_BINDING;


        static ModuleMethodKind ofMethod(ExecutableElement moduleMethod) {
            if (moduleMethod.getModifiers().contains((Object)Modifier.STATIC)) {
                return STATIC_BINDING;
            }
            if (moduleMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return ABSTRACT_DECLARATION;
            }
            return INSTANCE_BINDING;
        }
    }
}

