/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.InjectValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;

final class InjectBindingValidator
implements BindingGraphPlugin {
    private final InjectValidator injectValidator;

    @Inject
    InjectBindingValidator(InjectValidator injectValidator) {
        this.injectValidator = injectValidator.whenGeneratingCode();
    }

    public String pluginName() {
        return "Dagger/InjectBinding";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        bindingGraph.bindings().stream().filter(binding -> binding.kind().equals((Object)BindingKind.INJECTION)).forEach(binding -> this.validateInjectionBinding((Binding)binding, diagnosticReporter));
    }

    private void validateInjectionBinding(Binding node, DiagnosticReporter diagnosticReporter) {
        ValidationReport<TypeElement> typeReport = this.injectValidator.validateType(MoreTypes.asTypeElement(node.key().type()));
        for (ValidationReport.Item item : typeReport.allItems()) {
            diagnosticReporter.reportBinding(item.kind(), (BindingGraph.MaybeBinding)node, item.message());
        }
    }
}

