/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.BindsTypeChecker;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.RequestKinds;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.RequestKind;
import javax.lang.model.type.TypeMirror;

final class DelegateBindingExpression
extends BindingExpression {
    private final ContributionBinding binding;
    private final RequestKind requestKind;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;
    private final BindsTypeChecker bindsTypeChecker;

    DelegateBindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types, DaggerElements elements) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)resolvedBindings.contributionBinding());
        this.requestKind = (RequestKind)Preconditions.checkNotNull((Object)requestKind);
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.bindsTypeChecker = new BindsTypeChecker(types, elements);
    }

    static boolean isBindsScopeStrongerThanDependencyScope(ResolvedBindings resolvedBindings, BindingGraph graph) {
        ContributionBinding bindsBinding = resolvedBindings.contributionBinding();
        Preconditions.checkArgument((boolean)bindsBinding.kind().equals((Object)BindingKind.DELEGATE));
        Binding dependencyBinding = ((ResolvedBindings)graph.contributionBindings().get((Object)((DependencyRequest)Iterables.getOnlyElement(bindsBinding.dependencies())).key())).binding();
        ScopeKind bindsScope = ScopeKind.get(bindsBinding, graph);
        ScopeKind dependencyScope = ScopeKind.get(dependencyBinding, graph);
        return bindsScope.isStrongerScopeThan(dependencyScope);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression delegateExpression = this.componentBindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(((DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies())).key(), this.requestKind), requestingClass);
        TypeMirror contributedType = this.binding.contributedType();
        switch (this.requestKind) {
            case INSTANCE: {
                return this.instanceRequiresCast(delegateExpression, requestingClass) ? delegateExpression.castTo(contributedType) : delegateExpression;
            }
        }
        return this.castToRawTypeIfNecessary(delegateExpression, RequestKinds.requestType(this.requestKind, contributedType, this.types));
    }

    private boolean instanceRequiresCast(Expression delegateExpression, ClassName requestingClass) {
        return !this.bindsTypeChecker.isAssignable(delegateExpression.type(), this.binding.contributedType(), this.binding.contributionType()) && Accessibility.isTypeAccessibleFrom(this.binding.contributedType(), requestingClass.packageName());
    }

    private Expression castToRawTypeIfNecessary(Expression delegateExpression, TypeMirror desiredType) {
        if (this.types.isAssignable(delegateExpression.type(), desiredType)) {
            return delegateExpression;
        }
        return delegateExpression.castTo(this.types.erasure(desiredType));
    }

    private static enum ScopeKind {
        UNSCOPED,
        SINGLE_CHECK,
        DOUBLE_CHECK;


        static ScopeKind get(Binding binding, BindingGraph graph) {
            return binding.scope().map(scope -> scope.isReusable() ? SINGLE_CHECK : DOUBLE_CHECK).orElse(UNSCOPED);
        }

        boolean isStrongerScopeThan(ScopeKind other) {
            return this.ordinal() > other.ordinal();
        }
    }
}

