/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import dagger.BindsInstance;
import dagger.internal.codegen.ComponentCreatorAnnotation;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class ComponentCreatorValidator {
    private final DaggerElements elements;
    private final DaggerTypes types;

    @Inject
    ComponentCreatorValidator(DaggerElements elements, DaggerTypes types) {
        this.elements = elements;
        this.types = types;
    }

    public ValidationReport<TypeElement> validate(TypeElement type) {
        ValidationReport.Builder<TypeElement> report = ValidationReport.about(type);
        ImmutableSet<ComponentCreatorAnnotation> creatorAnnotations = ComponentCreatorAnnotation.getCreatorAnnotations(type);
        if (creatorAnnotations.size() > 1) {
            String error = "May not have more than one component Builder or Factory annotation on a type: found " + creatorAnnotations;
            report.addError(error);
            return report.build();
        }
        ComponentCreatorAnnotation creatorAnnotation = (ComponentCreatorAnnotation)((Object)Iterables.getOnlyElement(creatorAnnotations));
        ErrorMessages.ComponentCreatorMessages messages = ErrorMessages.creatorMessagesFor(creatorAnnotation);
        Element componentElement = type.getEnclosingElement();
        if (!MoreElements.isAnnotationPresent(componentElement, creatorAnnotation.componentAnnotation())) {
            report.addError(messages.mustBeInComponent());
        }
        if (this.validateIsClassOrInterface(type, report, messages)) {
            this.validateTypeRequirements(type, report, messages);
            switch (creatorAnnotation.creatorKind()) {
                case FACTORY: {
                    this.validateFactory(type, report, componentElement, messages);
                    break;
                }
                case BUILDER: {
                    this.validateBuilder(type, report, componentElement, messages);
                }
            }
        }
        return report.build();
    }

    private boolean validateIsClassOrInterface(TypeElement type, ValidationReport.Builder<TypeElement> report, ErrorMessages.ComponentCreatorMessages messages) {
        switch (type.getKind()) {
            case CLASS: {
                this.validateConstructor(type, report, messages);
                return true;
            }
            case INTERFACE: {
                return true;
            }
        }
        report.addError(messages.mustBeClassOrInterface());
        return false;
    }

    private void validateConstructor(TypeElement type, ValidationReport.Builder<TypeElement> report, ErrorMessages.ComponentCreatorMessages messages) {
        List<? extends Element> allElements = type.getEnclosedElements();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(allElements);
        boolean valid = true;
        if (constructors.size() != 1) {
            valid = false;
        } else {
            ExecutableElement constructor = (ExecutableElement)Iterables.getOnlyElement(constructors);
            boolean bl = valid = constructor.getParameters().isEmpty() && !constructor.getModifiers().contains((Object)Modifier.PRIVATE);
        }
        if (!valid) {
            report.addError(messages.invalidConstructor());
        }
    }

    private void validateTypeRequirements(TypeElement type, ValidationReport.Builder<TypeElement> report, ErrorMessages.ComponentCreatorMessages messages) {
        Set<Modifier> modifiers;
        if (!type.getTypeParameters().isEmpty()) {
            report.addError(messages.generics());
        }
        if ((modifiers = type.getModifiers()).contains((Object)Modifier.PRIVATE)) {
            report.addError(messages.isPrivate());
        }
        if (!modifiers.contains((Object)Modifier.STATIC)) {
            report.addError(messages.mustBeStatic());
        }
        if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
            report.addError(messages.mustBeAbstract());
        }
    }

    private void validateBuilder(TypeElement type, ValidationReport.Builder<TypeElement> report, Element componentElement, ErrorMessages.ComponentCreatorMessages messages) {
        ExecutableElement buildMethod = null;
        block4: for (ExecutableElement method : this.elements.getUnimplementedMethods(type)) {
            TypeMirror returnType = this.types.resolveExecutableType(method, type.asType()).getReturnType();
            switch (method.getParameters().size()) {
                case 0: {
                    if (this.validateFactoryMethodReturnType(report, type, componentElement, messages, method) && buildMethod != null) {
                        ComponentCreatorValidator.error(report, method, messages.twoFactoryMethods(), messages.inheritedTwoFactoryMethods(), buildMethod);
                    }
                    buildMethod = method;
                    continue block4;
                }
                case 1: {
                    this.validateSetterMethod(type, method, returnType, report, messages);
                    continue block4;
                }
            }
            ComponentCreatorValidator.error(report, method, messages.setterMethodsMustTakeOneArg(), messages.inheritedSetterMethodsMustTakeOneArg(), new Object[0]);
        }
        if (buildMethod == null) {
            report.addError(messages.missingFactoryMethod());
        } else {
            this.validateNotGeneric(buildMethod, report, messages);
        }
    }

    private void validateSetterMethod(TypeElement type, ExecutableElement method, TypeMirror returnType, ValidationReport.Builder<TypeElement> report, ErrorMessages.ComponentCreatorMessages messages) {
        boolean bindsInstance;
        if (returnType.getKind() != TypeKind.VOID && !this.types.isSubtype(type.asType(), returnType)) {
            ComponentCreatorValidator.error(report, method, messages.setterMethodsMustReturnVoidOrBuilder(), messages.inheritedSetterMethodsMustReturnVoidOrBuilder(), new Object[0]);
        }
        this.validateNotGeneric(method, report, messages);
        VariableElement parameter = method.getParameters().get(0);
        boolean methodIsBindsInstance = MoreElements.isAnnotationPresent(method, BindsInstance.class);
        boolean parameterIsBindsInstance = MoreElements.isAnnotationPresent(parameter, BindsInstance.class);
        boolean bl = bindsInstance = methodIsBindsInstance || parameterIsBindsInstance;
        if (methodIsBindsInstance && parameterIsBindsInstance) {
            ComponentCreatorValidator.error(report, method, messages.bindsInstanceNotAllowedOnBothSetterMethodAndParameter(), messages.inheritedBindsInstanceNotAllowedOnBothSetterMethodAndParameter(), new Object[0]);
        }
        if (!bindsInstance && parameter.asType().getKind().isPrimitive()) {
            ComponentCreatorValidator.error(report, method, messages.nonBindsInstanceParametersMayNotBePrimitives(), messages.inheritedNonBindsInstanceParametersMayNotBePrimitives(), new Object[0]);
        }
    }

    private void validateFactory(TypeElement type, ValidationReport.Builder<TypeElement> report, Element componentElement, ErrorMessages.ComponentCreatorMessages messages) {
        ImmutableList abstractMethods = this.elements.getUnimplementedMethods(type).asList();
        switch (abstractMethods.size()) {
            case 0: {
                report.addError(messages.missingFactoryMethod());
                return;
            }
            case 1: {
                break;
            }
            default: {
                ComponentCreatorValidator.error(report, (ExecutableElement)abstractMethods.get(1), messages.twoFactoryMethods(), messages.inheritedTwoFactoryMethods(), abstractMethods.get(0));
                return;
            }
        }
        ExecutableElement method = (ExecutableElement)Iterables.getOnlyElement((Iterable)abstractMethods);
        this.validateNotGeneric(method, report, messages);
        if (!this.validateFactoryMethodReturnType(report, type, componentElement, messages, method)) {
            return;
        }
        for (VariableElement variableElement : method.getParameters()) {
            if (MoreElements.isAnnotationPresent(variableElement, BindsInstance.class) || !variableElement.asType().getKind().isPrimitive()) continue;
            ComponentCreatorValidator.error(report, method, messages.nonBindsInstanceParametersMayNotBePrimitives(), messages.inheritedNonBindsInstanceParametersMayNotBePrimitives(), new Object[0]);
        }
    }

    private boolean validateFactoryMethodReturnType(ValidationReport.Builder<TypeElement> report, TypeElement type, Element componentElement, ErrorMessages.ComponentCreatorMessages messages, ExecutableElement method) {
        ImmutableSet<ExecutableElement> methodsOnlyInComponent;
        TypeMirror returnType = this.types.resolveExecutableType(method, type.asType()).getReturnType();
        if (!this.types.isSubtype(componentElement.asType(), returnType)) {
            ComponentCreatorValidator.error(report, method, messages.factoryMethodMustReturnComponentType(), messages.inheritedFactoryMethodMustReturnComponentType(), new Object[0]);
            return false;
        }
        if (MoreElements.isAnnotationPresent(method, BindsInstance.class)) {
            ComponentCreatorValidator.error(report, method, messages.factoryMethodMayNotBeAnnotatedWithBindsInstance(), messages.inheritedFactoryMethodMayNotBeAnnotatedWithBindsInstance(), new Object[0]);
            return false;
        }
        TypeElement componentType = MoreElements.asType(componentElement);
        if (!this.types.isSameType(componentType.asType(), returnType) && !(methodsOnlyInComponent = this.methodsOnlyInComponent(componentType)).isEmpty()) {
            report.addWarning(messages.factoryMethodReturnsSupertypeWithMissingMethods(componentType, report.getSubject(), returnType, method, (Set<ExecutableElement>)methodsOnlyInComponent), method);
        }
        return true;
    }

    private static void error(ValidationReport.Builder<TypeElement> report, ExecutableElement method, String enclosedError, String inheritedError, Object ... extraArgs) {
        if (method.getEnclosingElement().equals(report.getSubject())) {
            report.addError(String.format(enclosedError, extraArgs), method);
        } else {
            report.addError(String.format(inheritedError, ObjectArrays.concat((Object[])extraArgs, (Object)method)));
        }
    }

    private void validateNotGeneric(ExecutableElement method, ValidationReport.Builder<TypeElement> report, ErrorMessages.ComponentCreatorMessages messages) {
        if (!method.getTypeParameters().isEmpty()) {
            ComponentCreatorValidator.error(report, method, messages.methodsMayNotHaveTypeParameters(), messages.inheritedMethodsMayNotHaveTypeParameters(), new Object[0]);
        }
    }

    private ImmutableSet<ExecutableElement> methodsOnlyInComponent(TypeElement componentType) {
        return ImmutableSet.copyOf(ElementFilter.methodsIn(componentType.getEnclosedElements()));
    }
}

