/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.DiagnosticReporterFactory;
import dagger.internal.codegen.Validation;
import dagger.model.BindingGraph;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.tools.Diagnostic;

@Singleton
final class BindingGraphValidator {
    private final ImmutableSet<BindingGraphPlugin> validationPlugins;
    private final ImmutableSet<BindingGraphPlugin> externalPlugins;
    private final DiagnosticReporterFactory diagnosticReporterFactory;

    @Inject
    BindingGraphValidator(@Validation Set<BindingGraphPlugin> validationPlugins, ImmutableSet<BindingGraphPlugin> externalPlugins, DiagnosticReporterFactory diagnosticReporterFactory) {
        this.validationPlugins = ImmutableSet.copyOf(validationPlugins);
        this.externalPlugins = ImmutableSet.copyOf(externalPlugins);
        this.diagnosticReporterFactory = (DiagnosticReporterFactory)Preconditions.checkNotNull((Object)diagnosticReporterFactory);
    }

    boolean isValid(BindingGraph graph) {
        return this.isValid(this.validationPlugins, graph) && this.isValid(this.externalPlugins, graph);
    }

    private boolean isValid(ImmutableSet<BindingGraphPlugin> plugins, BindingGraph graph) {
        boolean isValid = true;
        for (BindingGraphPlugin plugin : plugins) {
            DiagnosticReporterFactory.DiagnosticReporterImpl reporter = this.diagnosticReporterFactory.reporter(graph, plugin);
            plugin.visitGraph(graph, (DiagnosticReporter)reporter);
            if (!reporter.reportedDiagnosticKinds().contains((Object)Diagnostic.Kind.ERROR)) continue;
            isValid = false;
        }
        return isValid;
    }
}

