/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.ModifiableBindingMethods;
import javax.lang.model.type.TypeMirror;

abstract class BindingExpression {
    BindingExpression() {
    }

    abstract Expression getDependencyExpression(ClassName var1);

    Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return this.getDependencyExpression(component.name());
    }

    boolean requiresMethodEncapsulation() {
        return false;
    }

    CodeBlock getComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return CodeBlock.of((String)"return $L;", (Object[])new Object[]{this.getDependencyExpressionForComponentMethod(componentMethod, component).codeBlock()});
    }

    CodeBlock getModifiableBindingMethodImplementation(ModifiableBindingMethods.ModifiableBindingMethod modifiableBindingMethod, ComponentImplementation component, DaggerTypes types) {
        Expression dependencyExpression = this.getDependencyExpression(component.name());
        TypeMirror returnType = modifiableBindingMethod.returnType();
        if (!types.isAssignable(dependencyExpression.type(), returnType) && Accessibility.isTypeAccessibleFrom(returnType, component.name().packageName())) {
            dependencyExpression = dependencyExpression.castTo(returnType);
        }
        return CodeBlock.of((String)"return $L;", (Object[])new Object[]{dependencyExpression.codeBlock()});
    }
}

