/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.InjectionMethod;
import java.util.Optional;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class AutoValue_InjectionMethod
extends InjectionMethod {
    private final String name;
    private final boolean varargs;
    private final ImmutableList<TypeVariableName> typeVariables;
    private final ImmutableMap<ParameterSpec, TypeMirror> parameters;
    private final Optional<TypeMirror> returnType;
    private final Optional<DeclaredType> nullableAnnotation;
    private final ImmutableList<TypeMirror> exceptions;
    private final CodeBlock methodBody;
    private final ClassName enclosingClass;

    private AutoValue_InjectionMethod(String name, boolean varargs, ImmutableList<TypeVariableName> typeVariables, ImmutableMap<ParameterSpec, TypeMirror> parameters, Optional<TypeMirror> returnType, Optional<DeclaredType> nullableAnnotation, ImmutableList<TypeMirror> exceptions, CodeBlock methodBody, ClassName enclosingClass) {
        this.name = name;
        this.varargs = varargs;
        this.typeVariables = typeVariables;
        this.parameters = parameters;
        this.returnType = returnType;
        this.nullableAnnotation = nullableAnnotation;
        this.exceptions = exceptions;
        this.methodBody = methodBody;
        this.enclosingClass = enclosingClass;
    }

    @Override
    String name() {
        return this.name;
    }

    @Override
    boolean varargs() {
        return this.varargs;
    }

    @Override
    ImmutableList<TypeVariableName> typeVariables() {
        return this.typeVariables;
    }

    @Override
    ImmutableMap<ParameterSpec, TypeMirror> parameters() {
        return this.parameters;
    }

    @Override
    Optional<TypeMirror> returnType() {
        return this.returnType;
    }

    @Override
    Optional<DeclaredType> nullableAnnotation() {
        return this.nullableAnnotation;
    }

    @Override
    ImmutableList<TypeMirror> exceptions() {
        return this.exceptions;
    }

    @Override
    CodeBlock methodBody() {
        return this.methodBody;
    }

    @Override
    ClassName enclosingClass() {
        return this.enclosingClass;
    }

    public String toString() {
        return "InjectionMethod{name=" + this.name + ", varargs=" + this.varargs + ", typeVariables=" + this.typeVariables + ", parameters=" + this.parameters + ", returnType=" + this.returnType + ", nullableAnnotation=" + this.nullableAnnotation + ", exceptions=" + this.exceptions + ", methodBody=" + this.methodBody + ", enclosingClass=" + this.enclosingClass + "}";
    }

    static final class Builder
    extends InjectionMethod.Builder {
        private String name;
        private Boolean varargs;
        private ImmutableList.Builder<TypeVariableName> typeVariablesBuilder$;
        private ImmutableList<TypeVariableName> typeVariables;
        private ImmutableMap.Builder<ParameterSpec, TypeMirror> parametersBuilder$;
        private ImmutableMap<ParameterSpec, TypeMirror> parameters;
        private Optional<TypeMirror> returnType = Optional.empty();
        private Optional<DeclaredType> nullableAnnotation = Optional.empty();
        private ImmutableList<TypeMirror> exceptions;
        private CodeBlock methodBody;
        private ClassName enclosingClass;

        Builder() {
            this.typeVariables = ImmutableList.of();
            this.parameters = ImmutableMap.of();
        }

        Builder(InjectionMethod source) {
            this.name = source.name();
            this.varargs = source.varargs();
            this.typeVariables = source.typeVariables();
            this.parameters = source.parameters();
            this.returnType = source.returnType();
            this.nullableAnnotation = source.nullableAnnotation();
            this.exceptions = source.exceptions();
            this.methodBody = source.methodBody();
            this.enclosingClass = source.enclosingClass();
        }

        @Override
        public InjectionMethod.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public InjectionMethod.Builder varargs(boolean varargs) {
            this.varargs = varargs;
            return this;
        }

        @Override
        public ImmutableList.Builder<TypeVariableName> typeVariablesBuilder() {
            if (this.typeVariablesBuilder$ == null) {
                this.typeVariablesBuilder$ = ImmutableList.builder();
                this.typeVariablesBuilder$.addAll(this.typeVariables);
                this.typeVariables = null;
            }
            return this.typeVariablesBuilder$;
        }

        @Override
        public ImmutableMap.Builder<ParameterSpec, TypeMirror> parametersBuilder() {
            if (this.parametersBuilder$ == null) {
                this.parametersBuilder$ = ImmutableMap.builder();
                this.parametersBuilder$.putAll(this.parameters);
                this.parameters = null;
            }
            return this.parametersBuilder$;
        }

        @Override
        public InjectionMethod.Builder returnType(TypeMirror returnType) {
            this.returnType = Optional.of(returnType);
            return this;
        }

        @Override
        public InjectionMethod.Builder nullableAnnotation(Optional<DeclaredType> nullableAnnotation) {
            this.nullableAnnotation = nullableAnnotation;
            return this;
        }

        @Override
        public InjectionMethod.Builder exceptions(Iterable<? extends TypeMirror> exceptions) {
            this.exceptions = ImmutableList.copyOf(exceptions);
            return this;
        }

        @Override
        public InjectionMethod.Builder methodBody(CodeBlock methodBody) {
            this.methodBody = methodBody;
            return this;
        }

        @Override
        public InjectionMethod.Builder enclosingClass(ClassName enclosingClass) {
            this.enclosingClass = enclosingClass;
            return this;
        }

        @Override
        public InjectionMethod buildInternal() {
            if (this.typeVariablesBuilder$ != null) {
                this.typeVariables = this.typeVariablesBuilder$.build();
            }
            if (this.parametersBuilder$ != null) {
                this.parameters = this.parametersBuilder$.build();
            }
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.varargs == null) {
                missing = missing + " varargs";
            }
            if (this.exceptions == null) {
                missing = missing + " exceptions";
            }
            if (this.methodBody == null) {
                missing = missing + " methodBody";
            }
            if (this.enclosingClass == null) {
                missing = missing + " enclosingClass";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_InjectionMethod(this.name, this.varargs, this.typeVariables, this.parameters, this.returnType, this.nullableAnnotation, this.exceptions, this.methodBody, this.enclosingClass);
        }
    }
}

