/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SimpleInvocationBindingExpression;
import dagger.model.DependencyRequest;
import dagger.model.RequestKind;
import java.util.Optional;

abstract class MultibindingExpression
extends SimpleInvocationBindingExpression {
    private final ProvisionBinding binding;
    private final ComponentImplementation componentImplementation;

    MultibindingExpression(ResolvedBindings resolvedBindings, ComponentImplementation componentImplementation) {
        super(resolvedBindings);
        this.componentImplementation = componentImplementation;
        this.binding = (ProvisionBinding)resolvedBindings.contributionBinding();
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression expression = this.buildDependencyExpression(requestingClass);
        this.componentImplementation.registerImplementedMultibinding(this.binding, this.bindingRequest());
        return expression;
    }

    protected abstract Expression buildDependencyExpression(ClassName var1);

    protected Sets.SetView<DependencyRequest> getNewContributions(ImmutableSet<DependencyRequest> dependencies) {
        return Sets.difference(dependencies, this.superclassContributions());
    }

    protected Optional<CodeBlock> superMethodCall() {
        Optional<ModifiableBindingMethods.ModifiableBindingMethod> method;
        if (this.componentImplementation.superclassImplementation().isPresent() && (method = this.componentImplementation.getModifiableBindingMethod(this.bindingRequest())).isPresent() && !this.superclassContributions().isEmpty()) {
            return Optional.of(CodeBlock.of((String)"super.$L()", (Object[])new Object[]{method.get().methodSpec().name}));
        }
        return Optional.empty();
    }

    private BindingRequest bindingRequest() {
        return BindingRequest.bindingRequest(this.binding.key(), RequestKind.INSTANCE);
    }

    private ImmutableSet<DependencyRequest> superclassContributions() {
        return this.componentImplementation.superclassContributionsMade(this.bindingRequest());
    }
}

