/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingMethodImplementation;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ProducerEntryPointView;
import java.util.Optional;

abstract class MethodBindingExpression
extends BindingExpression {
    private final BindingRequest request;
    private final BindingMethodImplementation methodImplementation;
    private final ComponentImplementation componentImplementation;
    private final ProducerEntryPointView producerEntryPointView;

    protected MethodBindingExpression(BindingRequest request, BindingMethodImplementation methodImplementation, ComponentImplementation componentImplementation, DaggerTypes types) {
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.methodImplementation = (BindingMethodImplementation)Preconditions.checkNotNull((Object)methodImplementation);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.producerEntryPointView = new ProducerEntryPointView(types);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        this.addMethod();
        return Expression.create(this.methodImplementation.returnType(), requestingClass.equals((Object)this.componentImplementation.name()) ? CodeBlock.of((String)"$N()", (Object[])new Object[]{this.methodName()}) : CodeBlock.of((String)"$T.this.$N()", (Object[])new Object[]{this.componentImplementation.name(), this.methodName()}));
    }

    @Override
    final CodeBlock getModifiableBindingMethodImplementation(ModifiableBindingMethods.ModifiableBindingMethod modifiableBindingMethod, ComponentImplementation component, DaggerTypes types) {
        if (this.supertypeModifiableBindingMethod().isPresent()) {
            Preconditions.checkState((boolean)this.supertypeModifiableBindingMethod().get().fulfillsSameRequestAs(modifiableBindingMethod));
            return this.methodImplementation.body();
        }
        return super.getModifiableBindingMethodImplementation(modifiableBindingMethod, component, types);
    }

    protected final Optional<ModifiableBindingMethods.ModifiableBindingMethod> supertypeModifiableBindingMethod() {
        return this.componentImplementation.supertypeModifiableBindingMethod(this.request);
    }

    @Override
    Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return this.producerEntryPointView.getProducerEntryPointField(this, componentMethod, component).orElseGet(() -> super.getDependencyExpressionForComponentMethod(componentMethod, component));
    }

    protected abstract void addMethod();

    protected abstract String methodName();
}

