/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.InjectionMethods;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Util;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class MembersInjectionMethods {
    private final Map<Key, MethodSpec> membersInjectionMethods = new LinkedHashMap<Key, MethodSpec>();
    private final ComponentImplementation componentImplementation;
    private final ComponentBindingExpressions bindingExpressions;
    private final BindingGraph graph;
    private final DaggerElements elements;
    private final DaggerTypes types;

    MembersInjectionMethods(ComponentImplementation componentImplementation, ComponentBindingExpressions bindingExpressions, BindingGraph graph, DaggerElements elements, DaggerTypes types) {
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.bindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)bindingExpressions);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
    }

    MethodSpec getOrCreate(Key key) {
        return Util.reentrantComputeIfAbsent(this.membersInjectionMethods, key, this::membersInjectionMethod);
    }

    private MethodSpec membersInjectionMethod(Key key) {
        ResolvedBindings resolvedBindings = (ResolvedBindings)this.graph.membersInjectionBindings().getOrDefault((Object)key, (Object)((ResolvedBindings)this.graph.contributionBindings().get((Object)key)));
        Binding binding = resolvedBindings.binding();
        TypeMirror keyType = binding.key().type();
        TypeMirror membersInjectedType = Accessibility.isTypeAccessibleFrom(keyType, this.componentImplementation.name().packageName()) ? keyType : this.elements.getTypeElement(Object.class).asType();
        TypeName membersInjectedTypeName = TypeName.get((TypeMirror)membersInjectedType);
        Name bindingTypeName = binding.bindingTypeElement().get().getSimpleName();
        String methodName = this.componentImplementation.getUniqueMethodName("inject" + bindingTypeName);
        ParameterSpec parameter = ParameterSpec.builder((TypeName)membersInjectedTypeName, (String)"instance", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(membersInjectedTypeName).addParameter(parameter);
        TypeElement canIgnoreReturnValue = this.elements.getTypeElement("com.google.errorprone.annotations.CanIgnoreReturnValue");
        if (canIgnoreReturnValue != null) {
            methodBuilder.addAnnotation(ClassName.get((TypeElement)canIgnoreReturnValue));
        }
        CodeBlock instance = CodeBlock.of((String)"$N", (Object[])new Object[]{parameter});
        methodBuilder.addCode(InjectionMethods.InjectionSiteMethod.invokeAll(MembersInjectionMethods.injectionSites(binding), this.componentImplementation.name(), instance, membersInjectedType, this.types, request -> this.bindingExpressions.getDependencyArgumentExpression((DependencyRequest)request, this.componentImplementation.name()).codeBlock()));
        methodBuilder.addStatement("return $L", new Object[]{instance});
        MethodSpec method = methodBuilder.build();
        this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.MEMBERS_INJECTION_METHOD, method);
        return method;
    }

    private static ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites(Binding binding) {
        if (binding instanceof ProvisionBinding) {
            return ((ProvisionBinding)binding).injectionSites();
        }
        if (binding instanceof MembersInjectionBinding) {
            return ((MembersInjectionBinding)binding).injectionSites();
        }
        throw new IllegalArgumentException(binding.key().toString());
    }
}

