/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.SourceFiles;
import dagger.model.Key;
import java.util.Iterator;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;

final class KeyVariableNamer {
    private static final TypeVisitor<Void, StringBuilder> TYPE_NAMER = new SimpleTypeVisitor8<Void, StringBuilder>(){

        @Override
        public Void visitDeclared(DeclaredType declaredType, StringBuilder builder) {
            Element element = declaredType.asElement();
            if (ConfigurationAnnotations.isSubcomponentCreator(element)) {
                builder.append(element.getEnclosingElement().getSimpleName());
            }
            builder.append(element.getSimpleName());
            Iterator<? extends TypeMirror> argumentIterator = declaredType.getTypeArguments().iterator();
            if (argumentIterator.hasNext()) {
                builder.append("Of");
                TypeMirror first = argumentIterator.next();
                first.accept(this, builder);
                while (argumentIterator.hasNext()) {
                    builder.append("And");
                    argumentIterator.next().accept(this, builder);
                }
            }
            return null;
        }

        @Override
        public Void visitPrimitive(PrimitiveType type, StringBuilder builder) {
            builder.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, type.toString()));
            return null;
        }

        @Override
        public Void visitArray(ArrayType type, StringBuilder builder) {
            type.getComponentType().accept(this, builder);
            builder.append("Array");
            return null;
        }
    };

    private KeyVariableNamer() {
    }

    static String name(Key key) {
        StringBuilder builder = new StringBuilder();
        if (key.qualifier().isPresent()) {
            builder.append(((AnnotationMirror)key.qualifier().get()).getAnnotationType().asElement().getSimpleName());
        }
        key.type().accept(TYPE_NAMER, builder);
        return SourceFiles.protectAgainstKeywords(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, builder.toString()));
    }
}

