/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphFactory;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentCreatorDescriptor;
import dagger.internal.codegen.ComponentCreatorImplementation;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementExpressions;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.SubcomponentNames;
import dagger.model.Key;
import dagger.producers.CancellationPolicy;
import dagger.producers.internal.CancellationListener;
import dagger.producers.internal.Producers;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class ComponentImplementationFactory {
    private static final String MAY_INTERRUPT_IF_RUNNING = "mayInterruptIfRunning";
    private static final int STATEMENTS_PER_METHOD = 100;
    private static final String CANCELLATION_LISTENER_METHOD_NAME = "onProducerFutureCancelled";
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final KeyFactory keyFactory;
    private final CompilerOptions compilerOptions;
    private final BindingGraphFactory bindingGraphFactory;

    @Inject
    ComponentImplementationFactory(DaggerTypes types, DaggerElements elements, KeyFactory keyFactory, CompilerOptions compilerOptions, BindingGraphFactory bindingGraphFactory) {
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.compilerOptions = compilerOptions;
        this.bindingGraphFactory = bindingGraphFactory;
    }

    ComponentImplementation createComponentImplementation(BindingGraph bindingGraph) {
        ComponentImplementation componentImplementation = this.topLevelImplementation(ComponentGenerator.componentName(bindingGraph.componentTypeElement()), bindingGraph);
        OptionalFactories optionalFactories = new OptionalFactories(componentImplementation);
        Optional<ComponentCreatorImplementation> componentCreatorImplementation = ComponentCreatorImplementation.create(componentImplementation, bindingGraph, this.elements, this.types);
        componentImplementation.setCreatorImplementation(componentCreatorImplementation);
        ComponentRequirementExpressions componentRequirementExpressions = new ComponentRequirementExpressions(bindingGraph, componentImplementation, this.types, this.elements);
        ComponentBindingExpressions bindingExpressions = new ComponentBindingExpressions(bindingGraph, componentImplementation, componentRequirementExpressions, optionalFactories, this.types, this.elements, this.compilerOptions);
        if (componentImplementation.isAbstract()) {
            Preconditions.checkState((boolean)this.compilerOptions.aheadOfTimeSubcomponents(), (String)"Calling 'componentImplementation()' on %s when not generating ahead-of-time subcomponents.", (Object)bindingGraph.componentTypeElement());
            return new SubcomponentImplementationBuilder(Optional.empty(), bindingGraph, componentImplementation, optionalFactories, bindingExpressions, componentRequirementExpressions).build();
        }
        return new RootComponentImplementationBuilder(bindingGraph, componentImplementation, optionalFactories, bindingExpressions, componentRequirementExpressions).build();
    }

    ComponentImplementation topLevelImplementation(ClassName name, BindingGraph graph) {
        return new ComponentImplementation(graph.componentDescriptor(), name, NestingKind.TOP_LEVEL, Optional.empty(), new SubcomponentNames(graph, this.keyFactory), Modifier.PUBLIC, graph.componentDescriptor().kind().isTopLevel() ? Modifier.FINAL : Modifier.ABSTRACT);
    }

    private static ImmutableList<ParameterSpec> getFactoryMethodParameterSpecs(BindingGraph graph) {
        return graph.factoryMethodParameters().values().stream().map(ParameterSpec::get).collect(DaggerStreams.toImmutableList());
    }

    private final class SubcomponentImplementationBuilder
    extends ComponentImplementationBuilder {
        final Optional<ComponentImplementationBuilder> parent;

        SubcomponentImplementationBuilder(Optional<ComponentImplementationBuilder> parent, BindingGraph graph, ComponentImplementation componentImplementation, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementExpressions componentRequirementExpressions) {
            super(graph, componentImplementation, optionalFactories, bindingExpressions, componentRequirementExpressions);
            this.parent = parent;
        }

        @Override
        void addCreatorClass(TypeSpec creator) {
            if (this.parent.isPresent()) {
                this.parent.get().componentImplementation.addType(ComponentImplementation.TypeSpecKind.SUBCOMPONENT, creator);
            } else {
                this.componentImplementation.addType(ComponentImplementation.TypeSpecKind.SUBCOMPONENT, creator);
            }
        }

        @Override
        void addFactoryMethods() {
            if (!this.componentImplementation.isAbstract()) {
                this.graph.factoryMethod().ifPresent(this::createSubcomponentFactoryMethod);
            }
        }

        void createSubcomponentFactoryMethod(ExecutableElement factoryMethod) {
            Preconditions.checkState((boolean)this.parent.isPresent());
            this.parent.get().componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.COMPONENT_METHOD, MethodSpec.overriding((ExecutableElement)factoryMethod, (DeclaredType)this.parentType(), (Types)ComponentImplementationFactory.this.types).addStatement("return new $T($L)", new Object[]{this.componentImplementation.name(), ComponentImplementationFactory.getFactoryMethodParameterSpecs(this.graph).stream().map(param -> CodeBlock.of((String)"$N", (Object[])new Object[]{param})).collect(CodeBlocks.toParametersCodeBlock())}).build());
        }

        DeclaredType parentType() {
            return MoreTypes.asDeclared(this.parent.get().graph.componentTypeElement().asType());
        }

        @Override
        void addInterfaceMethods() {
            if (this.componentImplementation.superclassImplementation().isPresent()) {
                ComponentImplementation superclassImplementation = this.componentImplementation.superclassImplementation().get();
                for (ModifiableBindingMethods.ModifiableBindingMethod superclassModifiableBindingMethod : superclassImplementation.getModifiableBindingMethods()) {
                    this.bindingExpressions.modifiableBindingExpressions().reimplementedModifiableBindingMethod(superclassModifiableBindingMethod).ifPresent(this.componentImplementation::addImplementedModifiableBindingMethod);
                }
            } else {
                super.addInterfaceMethods();
            }
        }

        @Override
        Optional<CodeBlock> cancelParentStatement() {
            if (!this.shouldPropagateCancellationToParent()) {
                return Optional.empty();
            }
            return Optional.of(CodeBlock.builder().addStatement("$T.this.$N($N)", new Object[]{this.parent.get().componentImplementation.name(), ComponentImplementationFactory.CANCELLATION_LISTENER_METHOD_NAME, ComponentImplementationFactory.MAY_INTERRUPT_IF_RUNNING}).build());
        }

        boolean shouldPropagateCancellationToParent() {
            return this.parent.isPresent() && this.parent.get().componentImplementation.componentDescriptor().cancellationPolicy().map(policy -> policy.fromSubcomponents().equals((Object)CancellationPolicy.Propagation.PROPAGATE)).orElse(false) != false;
        }
    }

    private final class RootComponentImplementationBuilder
    extends ComponentImplementationBuilder {
        private final ClassName componentCreatorName;

        RootComponentImplementationBuilder(BindingGraph graph, ComponentImplementation componentImplementation, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementExpressions componentRequirementExpressions) {
            super(graph, componentImplementation, optionalFactories, bindingExpressions, componentRequirementExpressions);
            this.componentCreatorName = componentImplementation.creatorImplementation().get().name();
        }

        @Override
        void addCreatorClass(TypeSpec creator) {
            this.componentImplementation.addType(ComponentImplementation.TypeSpecKind.COMPONENT_CREATOR, creator);
        }

        @Override
        void addFactoryMethods() {
            MethodSpec creatorFactoryMethod = MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.creatorDescriptor().map(creatorDescriptor -> ClassName.get((TypeElement)creatorDescriptor.typeElement())).orElse(this.componentCreatorName)).addStatement("return new $T()", new Object[]{this.componentCreatorName}).build();
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.BUILDER_METHOD, creatorFactoryMethod);
            if (this.canInstantiateAllRequirements()) {
                String buildMethodName = this.creatorDescriptor().isPresent() ? this.creatorDescriptor().get().factoryMethod().getSimpleName() : "build";
                this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)"create").returns((TypeName)ClassName.get((TypeElement)this.graph.componentTypeElement())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new Builder().$L()", new Object[]{buildMethodName}).build());
            }
        }

        private Optional<ComponentCreatorDescriptor> creatorDescriptor() {
            return this.graph.componentDescriptor().creatorDescriptor();
        }

        boolean canInstantiateAllRequirements() {
            return !Iterables.any(this.graph.componentRequirements(), dependency -> dependency.requiresAPassedInstance(ComponentImplementationFactory.this.elements, ComponentImplementationFactory.this.types));
        }
    }

    private abstract class ComponentImplementationBuilder {
        final BindingGraph graph;
        final ComponentBindingExpressions bindingExpressions;
        final ComponentRequirementExpressions componentRequirementExpressions;
        final ComponentImplementation componentImplementation;
        final OptionalFactories optionalFactories;
        boolean done;

        ComponentImplementationBuilder(BindingGraph graph, ComponentImplementation componentImplementation, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementExpressions componentRequirementExpressions) {
            this.graph = graph;
            this.componentImplementation = componentImplementation;
            this.optionalFactories = optionalFactories;
            this.bindingExpressions = bindingExpressions;
            this.componentRequirementExpressions = componentRequirementExpressions;
        }

        final ComponentImplementation build() {
            Preconditions.checkState((!this.done ? 1 : 0) != 0, (String)"ComponentImplementationBuilder has already built the ComponentImplementation for [%s].", (Object)this.componentImplementation.name());
            this.setSupertype();
            this.componentImplementation.creatorImplementation().map(ComponentCreatorImplementation::componentCreatorClass).ifPresent(this::addCreatorClass);
            MoreElements.getLocalAndInheritedMethods(this.graph.componentTypeElement(), ComponentImplementationFactory.this.types, ComponentImplementationFactory.this.elements).forEach(method -> this.componentImplementation.claimMethodName(method.getSimpleName()));
            this.componentImplementation.superclassImplementation().ifPresent(superclassImplementation -> superclassImplementation.getAllModifiableMethodNames().forEach(this.componentImplementation::claimMethodName));
            this.addFactoryMethods();
            this.addInterfaceMethods();
            this.addChildComponents();
            this.implementModifiableModuleMethods();
            this.addConstructor();
            if (this.graph.componentDescriptor().kind().isProducer()) {
                this.addCancellationListenerImplementation();
            }
            this.done = true;
            return this.componentImplementation;
        }

        final void setSupertype() {
            if (this.componentImplementation.superclassImplementation().isPresent()) {
                this.componentImplementation.addSuperclass(this.componentImplementation.superclassImplementation().get().name());
            } else {
                this.componentImplementation.addSupertype(this.graph.componentTypeElement());
            }
        }

        abstract void addCreatorClass(TypeSpec var1);

        abstract void addFactoryMethods();

        void addInterfaceMethods() {
            ImmutableListMultimap componentMethodsBySignature = Multimaps.index(this.graph.componentDescriptor().entryPointMethods(), this::getMethodSignature);
            for (List methodsWithSameSignature : Multimaps.asMap((ListMultimap)componentMethodsBySignature).values()) {
                ComponentDescriptor.ComponentMethodDescriptor anyOneMethod = (ComponentDescriptor.ComponentMethodDescriptor)methodsWithSameSignature.stream().findAny().get();
                MethodSpec methodSpec = this.bindingExpressions.getComponentMethod(anyOneMethod);
                ModifiableBindingType modifiableBindingType = this.bindingExpressions.modifiableBindingExpressions().registerComponentMethodIfModifiable(anyOneMethod, methodSpec);
                if (!modifiableBindingType.hasBaseClassImplementation()) continue;
                this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.COMPONENT_METHOD, methodSpec);
            }
        }

        final void addCancellationListenerImplementation() {
            ImmutableList<CodeBlock> cancellationStatements;
            this.componentImplementation.addSupertype(ComponentImplementationFactory.this.elements.getTypeElement(CancellationListener.class));
            this.componentImplementation.claimMethodName(ComponentImplementationFactory.CANCELLATION_LISTENER_METHOD_NAME);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ComponentImplementationFactory.CANCELLATION_LISTENER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Boolean.TYPE, ComponentImplementationFactory.MAY_INTERRUPT_IF_RUNNING, new Modifier[0]);
            if (this.componentImplementation.superclassImplementation().isPresent()) {
                methodBuilder.addStatement("super.$L($L)", new Object[]{ComponentImplementationFactory.CANCELLATION_LISTENER_METHOD_NAME, ComponentImplementationFactory.MAY_INTERRUPT_IF_RUNNING});
            }
            if ((cancellationStatements = this.cancellationStatements()).size() < 100) {
                methodBuilder.addCode(CodeBlocks.concat(cancellationStatements)).build();
            } else {
                List partitions = Lists.partition(cancellationStatements, (int)100);
                for (List partition : partitions) {
                    String methodName = this.componentImplementation.getUniqueMethodName("cancelProducers");
                    MethodSpec method = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(Boolean.TYPE, ComponentImplementationFactory.MAY_INTERRUPT_IF_RUNNING, new Modifier[0]).addCode(CodeBlocks.concat(partition)).build();
                    methodBuilder.addStatement("$N($L)", new Object[]{method, ComponentImplementationFactory.MAY_INTERRUPT_IF_RUNNING});
                    this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.CANCELLATION_LISTENER_METHOD, method);
                }
            }
            Optional<CodeBlock> cancelParentStatement = this.cancelParentStatement();
            cancelParentStatement.ifPresent(arg_0 -> ((MethodSpec.Builder)methodBuilder).addCode(arg_0));
            if (cancellationStatements.isEmpty() && !cancelParentStatement.isPresent() && this.componentImplementation.superclassImplementation().isPresent()) {
                return;
            }
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.CANCELLATION_LISTENER_METHOD, methodBuilder.build());
        }

        private ImmutableList<CodeBlock> cancellationStatements() {
            ImmutableList cancellationKeys = this.componentImplementation.getCancellableProducerKeys().reverse();
            ImmutableList.Builder cancellationStatements = ImmutableList.builder();
            for (Key cancellationKey : cancellationKeys) {
                cancellationStatements.add((Object)CodeBlock.of((String)"$T.cancel($L, $N);", (Object[])new Object[]{Producers.class, this.bindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(cancellationKey, FrameworkType.PRODUCER_NODE), this.componentImplementation.name()).codeBlock(), ComponentImplementationFactory.MAY_INTERRUPT_IF_RUNNING}));
            }
            return cancellationStatements.build();
        }

        Optional<CodeBlock> cancelParentStatement() {
            return Optional.empty();
        }

        private void implementModifiableModuleMethods() {
            if (this.componentImplementation.isAbstract()) {
                return;
            }
            this.componentImplementation.getAllModifiableModuleMethods().forEach(this::implementModifiableModuleMethod);
        }

        private void implementModifiableModuleMethod(ComponentRequirement module, String methodName) {
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.MODIFIABLE_BINDING_METHOD, MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TypeName.get((TypeMirror)module.type())).addStatement("return $L", new Object[]{this.componentRequirementExpressions.getExpression(module, this.componentImplementation.name())}).build());
        }

        final MethodSignature getMethodSignature(ComponentDescriptor.ComponentMethodDescriptor method) {
            return MethodSignature.forComponentMethod(method, MoreTypes.asDeclared(this.graph.componentTypeElement().asType()), ComponentImplementationFactory.this.types);
        }

        final void addChildComponents() {
            for (BindingGraph subgraph : this.graph.subgraphs()) {
                this.componentImplementation.addChild(subgraph.componentDescriptor(), this.buildChildImplementation(subgraph));
            }
        }

        final ComponentImplementation getChildSuperclassImplementation(ComponentDescriptor child) {
            Optional<ComponentImplementation> currentSuperclassImplementation = this.componentImplementation.superclassImplementation();
            while (currentSuperclassImplementation.isPresent()) {
                Optional<ComponentImplementation> childSuperclassImplementation = currentSuperclassImplementation.get().childImplementation(child);
                if (childSuperclassImplementation.isPresent()) {
                    return childSuperclassImplementation.get();
                }
                currentSuperclassImplementation = currentSuperclassImplementation.get().superclassImplementation();
            }
            BindingGraph truncatedBindingGraph = ComponentImplementationFactory.this.bindingGraphFactory.create(child);
            return ComponentImplementationFactory.this.createComponentImplementation(truncatedBindingGraph);
        }

        final ComponentImplementation buildChildImplementation(BindingGraph childGraph) {
            ComponentImplementation childImplementation = ComponentImplementationFactory.this.compilerOptions.aheadOfTimeSubcomponents() ? this.abstractInnerSubcomponent(childGraph.componentDescriptor()) : this.concreteSubcomponent(childGraph.componentDescriptor());
            Optional<ComponentCreatorImplementation> childCreatorImplementation = ComponentCreatorImplementation.create(childImplementation, childGraph, ComponentImplementationFactory.this.elements, ComponentImplementationFactory.this.types);
            childImplementation.setCreatorImplementation(childCreatorImplementation);
            ComponentRequirementExpressions childComponentRequirementExpressions = this.componentRequirementExpressions.forChildComponent(childGraph, childImplementation);
            ComponentBindingExpressions childBindingExpressions = this.bindingExpressions.forChildComponent(childGraph, childImplementation, childComponentRequirementExpressions);
            return new SubcomponentImplementationBuilder(Optional.of(this), childGraph, childImplementation, this.optionalFactories, childBindingExpressions, childComponentRequirementExpressions).build();
        }

        final ComponentImplementation abstractInnerSubcomponent(ComponentDescriptor child) {
            return new ComponentImplementation(this.componentImplementation, child, Optional.of(this.getChildSuperclassImplementation(child)), Modifier.PROTECTED, this.componentImplementation.isAbstract() ? Modifier.ABSTRACT : Modifier.FINAL);
        }

        final ComponentImplementation concreteSubcomponent(ComponentDescriptor child) {
            return new ComponentImplementation(this.componentImplementation, child, Optional.empty(), Modifier.PRIVATE, Modifier.FINAL);
        }

        final void addConstructor() {
            List partitions = Lists.partition(this.componentImplementation.getInitializations(), (int)100);
            ImmutableList<CodeBlock> componentRequirementInitializations = this.componentImplementation.getComponentRequirementInitializations();
            ImmutableList<ParameterSpec> constructorParameters = this.constructorParameters();
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{this.componentImplementation.isAbstract() ? Modifier.PROTECTED : Modifier.PRIVATE});
            if (!this.componentImplementation.isAbstract()) {
                constructor.addParameters(constructorParameters);
            }
            Optional<MethodSpec.Builder> configureInitialization = partitions.isEmpty() && componentRequirementInitializations.isEmpty() || !this.componentImplementation.isAbstract() ? Optional.empty() : Optional.of(this.configureInitializationMethodBuilder(constructorParameters));
            configureInitialization.orElse(constructor).addCode(CodeBlocks.concat(componentRequirementInitializations));
            if (this.componentImplementation.superConfigureInitializationMethod().isPresent()) {
                MethodSpec superConfigureInitializationMethod = this.componentImplementation.superConfigureInitializationMethod().get();
                CodeBlock superInvocation = CodeBlock.of((String)"$N($L)", (Object[])new Object[]{superConfigureInitializationMethod, CodeBlocks.parameterNames(superConfigureInitializationMethod.parameters)});
                if (configureInitialization.isPresent()) {
                    ((MethodSpec.Builder)configureInitialization.get()).addStatement("super.$L", new Object[]{superInvocation});
                } else if (!this.componentImplementation.isAbstract()) {
                    constructor.addStatement(superInvocation);
                }
            }
            ImmutableList<ParameterSpec> initializeParameters = this.initializeParameters();
            CodeBlock initializeParametersCodeBlock = CodeBlocks.parameterNames(constructorParameters);
            for (List partition : partitions) {
                String methodName = this.componentImplementation.getUniqueMethodName("initialize");
                MethodSpec.Builder initializeMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).addCode(CodeBlocks.concat(partition));
                initializeMethod.addParameters(initializeParameters);
                configureInitialization.orElse(constructor).addStatement("$L($L)", new Object[]{methodName, initializeParametersCodeBlock});
                this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.INITIALIZE_METHOD, initializeMethod.build());
            }
            this.componentImplementation.addMethod(ComponentImplementation.MethodSpecKind.CONSTRUCTOR, constructor.build());
            configureInitialization.ifPresent(method -> this.componentImplementation.setConfigureInitializationMethod(method.build()));
        }

        private MethodSpec.Builder configureInitializationMethodBuilder(ImmutableList<ParameterSpec> initializationMethodParameters) {
            String methodName = this.componentImplementation.getUniqueMethodName("configureInitialization");
            MethodSpec.Builder configureInitialization = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameters(initializationMethodParameters);
            Optional<ComponentImplementation> currentSuperImplementation = this.componentImplementation.superclassImplementation();
            while (currentSuperImplementation.isPresent()) {
                Optional<MethodSpec> superConfigureInitializationMethod = currentSuperImplementation.get().configureInitializationMethod();
                if (superConfigureInitializationMethod.filter(superMethod -> superMethod.name.equals(methodName)).filter(superMethod -> superMethod.parameters.equals(initializationMethodParameters)).isPresent()) {
                    configureInitialization.addAnnotation(Override.class);
                    break;
                }
                currentSuperImplementation = currentSuperImplementation.get().superclassImplementation();
            }
            return configureInitialization;
        }

        final ImmutableList<ParameterSpec> initializeParameters() {
            return this.constructorParameters().stream().map(param -> param.toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build()).collect(DaggerStreams.toImmutableList());
        }

        final ImmutableList<ParameterSpec> constructorParameters() {
            Optional<ClassName> componentCreatorName = this.componentImplementation.creatorImplementation().isPresent() ? this.componentImplementation.creatorImplementation().map(creator -> creator.name()) : this.componentImplementation.baseImplementation().filter(component -> component.componentDescriptor().hasCreator()).map(ComponentImplementation::getCreatorName);
            if (componentCreatorName.isPresent()) {
                return ImmutableList.of((Object)ParameterSpec.builder((TypeName)((TypeName)componentCreatorName.get()), (String)"builder", (Modifier[])new Modifier[0]).build());
            }
            if (this.componentImplementation.isAbstract() && this.componentImplementation.isNested()) {
                return ImmutableList.of();
            }
            if (this.graph.factoryMethod().isPresent()) {
                return ComponentImplementationFactory.getFactoryMethodParameterSpecs(this.graph);
            }
            if (this.componentImplementation.isAbstract()) {
                return ImmutableList.of();
            }
            throw new AssertionError((Object)"Expected either a component creator or factory method but found neither.");
        }
    }
}

