/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import dagger.internal.codegen.AutoValue_Binding_DependencyAssociation;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkTypeMapper;
import dagger.internal.codegen.SourceFiles;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

abstract class Binding
extends BindingDeclaration {
    private final Supplier<ImmutableSet<DependencyRequest>> dependencies = Suppliers.memoize(() -> {
        ImmutableSet<DependencyRequest> implicitDependencies = this.implicitDependencies();
        return ImmutableSet.copyOf(implicitDependencies.isEmpty() ? this.explicitDependencies() : Sets.union(implicitDependencies, this.explicitDependencies()));
    });
    private final Supplier<ImmutableList<FrameworkDependency>> frameworkDependencies = Suppliers.memoize(() -> this.dependencyAssociations().stream().map(DependencyAssociation::frameworkDependency).collect(DaggerStreams.toImmutableList()));
    private final Supplier<ImmutableList<DependencyAssociation>> dependencyAssociations = Suppliers.memoize(() -> {
        FrameworkTypeMapper frameworkTypeMapper = FrameworkTypeMapper.forBindingType(this.bindingType());
        ImmutableList.Builder list = ImmutableList.builder();
        for (Set requests : this.groupByUnresolvedKey()) {
            list.add((Object)DependencyAssociation.create(FrameworkDependency.create((Key)Iterables.getOnlyElement((Iterable)requests.stream().map(DependencyRequest::key).collect(Collectors.toSet())), frameworkTypeMapper.getFrameworkType(requests)), requests));
        }
        return list.build();
    });
    private final Supplier<ImmutableMap<DependencyRequest, FrameworkDependency>> frameworkDependenciesMap = Suppliers.memoize(() -> {
        ImmutableMap.Builder frameworkDependencies = ImmutableMap.builder();
        for (DependencyAssociation dependencyAssociation : this.dependencyAssociations()) {
            for (DependencyRequest dependencyRequest : dependencyAssociation.dependencyRequests()) {
                frameworkDependencies.put((Object)dependencyRequest, (Object)dependencyAssociation.frameworkDependency());
            }
        }
        return frameworkDependencies.build();
    });

    Binding() {
    }

    boolean requiresModuleInstance() {
        if (!this.bindingElement().isPresent() || !this.contributingModule().isPresent()) {
            return false;
        }
        Set<Modifier> modifiers = this.bindingElement().get().getModifiers();
        return !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC);
    }

    abstract boolean isNullable();

    abstract BindingKind kind();

    abstract BindingType bindingType();

    abstract ImmutableSet<DependencyRequest> explicitDependencies();

    ImmutableSet<DependencyRequest> implicitDependencies() {
        return ImmutableSet.of();
    }

    ImmutableSet<DependencyRequest> dependencies() {
        return (ImmutableSet)this.dependencies.get();
    }

    ImmutableList<FrameworkDependency> frameworkDependencies() {
        return (ImmutableList)this.frameworkDependencies.get();
    }

    ImmutableList<DependencyAssociation> dependencyAssociations() {
        return (ImmutableList)this.dependencyAssociations.get();
    }

    ImmutableMap<DependencyRequest, FrameworkDependency> dependenciesToFrameworkDependenciesMap() {
        return (ImmutableMap)this.frameworkDependenciesMap.get();
    }

    private ImmutableList<Set<DependencyRequest>> groupByUnresolvedKey() {
        ImmutableSetMultimap.Builder dependenciesByKeyBuilder = ImmutableSetMultimap.builder();
        UnmodifiableIterator dependencies = this.dependencies().iterator();
        Binding unresolved = this.unresolved().isPresent() ? this.unresolved().get() : this;
        UnmodifiableIterator unresolvedDependencies = unresolved.dependencies().iterator();
        while (dependencies.hasNext()) {
            dependenciesByKeyBuilder.put((Object)((DependencyRequest)unresolvedDependencies.next()).key(), (Object)((DependencyRequest)dependencies.next()));
        }
        return ImmutableList.copyOf(Multimaps.asMap((SetMultimap)dependenciesByKeyBuilder.orderValuesBy(SourceFiles.DEPENDENCY_ORDERING).build()).values());
    }

    abstract Optional<? extends Binding> unresolved();

    Optional<Scope> scope() {
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    static boolean hasNonDefaultTypeParameters(TypeElement element, TypeMirror type, Types types) {
        void var5_7;
        if (element.getTypeParameters().isEmpty()) {
            return false;
        }
        ArrayList defaultTypes = Lists.newArrayList();
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            defaultTypes.add(typeParameterElement.asType());
        }
        List<TypeMirror> actualTypes = type.accept(new SimpleTypeVisitor6<List<TypeMirror>, Void>(){

            @Override
            protected List<TypeMirror> defaultAction(TypeMirror e, Void p) {
                return ImmutableList.of();
            }

            @Override
            public List<TypeMirror> visitDeclared(DeclaredType t, Void p) {
                return ImmutableList.copyOf(t.getTypeArguments());
            }
        }, null);
        if (defaultTypes.size() != actualTypes.size()) {
            return true;
        }
        boolean bl = false;
        while (var5_7 < defaultTypes.size()) {
            if (!types.isSameType((TypeMirror)defaultTypes.get((int)var5_7), actualTypes.get((int)var5_7))) {
                return true;
            }
            ++var5_7;
        }
        return false;
    }

    @AutoValue
    static abstract class DependencyAssociation {
        DependencyAssociation() {
        }

        abstract FrameworkDependency frameworkDependency();

        abstract ImmutableSet<DependencyRequest> dependencyRequests();

        static DependencyAssociation create(FrameworkDependency frameworkDependency, Iterable<DependencyRequest> dependencyRequests) {
            return new AutoValue_Binding_DependencyAssociation(frameworkDependency, (ImmutableSet<DependencyRequest>)ImmutableSet.copyOf(dependencyRequests));
        }
    }
}

