/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.ValidationReport;
import dagger.multibindings.Multibinds;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class MultibindsMethodValidator
extends BindingMethodValidator {
    @Inject
    MultibindsMethodValidator(DaggerElements elements, Types types) {
        super(elements, types, Multibinds.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingMethodValidator.AllowsMultibindings.NO_MULTIBINDINGS);
    }

    @Override
    protected void checkMethod(ValidationReport.Builder<ExecutableElement> builder) {
        super.checkMethod(builder);
        this.checkParameters(builder);
    }

    private void checkParameters(ValidationReport.Builder<ExecutableElement> builder) {
        if (!builder.getSubject().getParameters().isEmpty()) {
            builder.addError(this.formatErrorMessage("@%s methods cannot have parameters", new Object[0]));
        }
    }

    @Override
    protected void checkReturnType(ValidationReport.Builder<ExecutableElement> builder) {
        if (!this.isPlainMap(builder.getSubject().getReturnType()) && !this.isPlainSet(builder.getSubject().getReturnType())) {
            builder.addError(this.formatErrorMessage("@%s methods must return Map<K, V> or Set<T>", new Object[0]));
        }
    }

    private boolean isPlainMap(TypeMirror returnType) {
        if (!MapType.isMap(returnType)) {
            return false;
        }
        MapType mapType = MapType.from(returnType);
        return !mapType.isRawType() && MoreTypes.isType(mapType.valueType()) && !FrameworkTypes.isFrameworkType(mapType.valueType());
    }

    private boolean isPlainSet(TypeMirror returnType) {
        if (!SetType.isSet(returnType)) {
            return false;
        }
        SetType setType = SetType.from(returnType);
        return !setType.isRawType() && MoreTypes.isType(setType.elementType()) && !FrameworkTypes.isFrameworkType(setType.elementType());
    }
}

