/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.shaded.auto.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dagger.android.shaded.auto.common.MoreElements;
import dagger.android.shaded.auto.common.MoreTypes;
import dagger.android.shaded.auto.common.Visibility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class Overrides {
    Overrides() {
    }

    abstract boolean overrides(ExecutableElement var1, ExecutableElement var2, TypeElement var3);

    static class ExplicitOverrides
    extends Overrides {
        private final Types typeUtils;

        ExplicitOverrides(Types typeUtils) {
            this.typeUtils = typeUtils;
        }

        @Override
        public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement in) {
            if (!overrider.getSimpleName().equals(overridden.getSimpleName())) {
                return false;
            }
            if (overrider.getEnclosingElement().equals(overridden.getEnclosingElement())) {
                return false;
            }
            if (overridden.getModifiers().contains((Object)Modifier.STATIC)) {
                return false;
            }
            Visibility overriddenVisibility = Visibility.ofElement(overridden);
            Visibility overriderVisibility = Visibility.ofElement(overrider);
            if (overriddenVisibility.equals((Object)Visibility.PRIVATE) || overriderVisibility.compareTo(overriddenVisibility) < 0) {
                return false;
            }
            if (!this.isSubsignature(overrider, overridden, in)) {
                return false;
            }
            if (!MoreElements.methodVisibleFromPackage(overridden, MoreElements.getPackage(overrider))) {
                return false;
            }
            if (!MoreElements.isType(overridden.getEnclosingElement())) {
                return false;
            }
            TypeElement overriddenType = MoreElements.asType(overridden.getEnclosingElement());
            if (!this.typeUtils.isSubtype(this.typeUtils.erasure(in.asType()), this.typeUtils.erasure(overriddenType.asType()))) {
                return false;
            }
            if (in.getKind().isClass()) {
                if (overriddenType.getKind().isClass()) {
                    ExecutableElement inherited = this.methodFromSuperclasses(in, overridden);
                    return inherited != null && !overridden.getEnclosingElement().equals(inherited.getEnclosingElement());
                }
                if (overriddenType.getKind().isInterface()) {
                    if (overrider.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        ExecutableElement inherited = this.methodFromSuperinterfaces(in, overridden);
                        return inherited != null && !overridden.getEnclosingElement().equals(inherited.getEnclosingElement());
                    }
                    return true;
                }
                return false;
            }
            TypeElement overriderType = MoreElements.asType(overrider.getEnclosingElement());
            return in.getKind().isInterface() && this.typeUtils.isSubtype(this.typeUtils.erasure(overriderType.asType()), this.typeUtils.erasure(overriddenType.asType()));
        }

        private boolean isSubsignature(ExecutableElement overrider, ExecutableElement overridden, TypeElement in) {
            DeclaredType inType = MoreTypes.asDeclared(in.asType());
            try {
                ExecutableType overriderExecutable = MoreTypes.asExecutable(this.typeUtils.asMemberOf(inType, overrider));
                ExecutableType overriddenExecutable = MoreTypes.asExecutable(this.typeUtils.asMemberOf(inType, overridden));
                return this.typeUtils.isSubsignature(overriderExecutable, overriddenExecutable);
            }
            catch (IllegalArgumentException e) {
                int nParams = overrider.getParameters().size();
                if (overridden.getParameters().size() != nParams) {
                    return false;
                }
                ImmutableList<TypeMirror> overriderParams = this.erasedParameterTypes(overrider, in);
                ImmutableList<TypeMirror> overriddenParams = this.erasedParameterTypes(overridden, in);
                if (overriderParams == null || overriddenParams == null) {
                    return false;
                }
                for (int i = 0; i < nParams; ++i) {
                    if (this.typeUtils.isSameType((TypeMirror)overriderParams.get(i), (TypeMirror)overriddenParams.get(i))) continue;
                    return false;
                }
                return true;
            }
        }

        @Nullable ImmutableList<TypeMirror> erasedParameterTypes(ExecutableElement method, TypeElement in) {
            if (method.getParameters().isEmpty()) {
                return ImmutableList.of();
            }
            return new TypeSubstVisitor().erasedParameterTypes(method, in);
        }

        @Nullable ExecutableElement methodFromSuperclasses(TypeElement in, ExecutableElement method) {
            TypeElement t = in;
            while (t != null) {
                ExecutableElement tMethod = this.methodInType(t, method);
                if (tMethod != null) {
                    return tMethod;
                }
                t = this.superclass(t);
            }
            return null;
        }

        @Nullable ExecutableElement methodFromSuperinterfaces(TypeElement in, ExecutableElement method) {
            TypeElement methodContainer = MoreElements.asType(method.getEnclosingElement());
            Preconditions.checkArgument((boolean)methodContainer.getKind().isInterface());
            TypeMirror methodContainerType = this.typeUtils.erasure(methodContainer.asType());
            ImmutableList types = ImmutableList.of((Object)in);
            while (!types.isEmpty()) {
                ImmutableList.Builder newTypes = ImmutableList.builder();
                for (TypeElement t : types) {
                    TypeElement sup;
                    TypeMirror candidateType = this.typeUtils.erasure(t.asType());
                    if (this.typeUtils.isAssignable(candidateType, methodContainerType)) {
                        ExecutableElement tMethod = this.methodInType(t, method);
                        if (tMethod != null) {
                            return tMethod;
                        }
                        newTypes.addAll(this.superinterfaces(t));
                    }
                    if (!t.getKind().isClass() || (sup = this.superclass(t)) == null) continue;
                    newTypes.add((Object)sup);
                }
                types = newTypes.build();
            }
            return null;
        }

        private @Nullable ExecutableElement methodInType(TypeElement type, ExecutableElement method) {
            int nParams = method.getParameters().size();
            ImmutableList<TypeMirror> params = this.erasedParameterTypes(method, type);
            if (params == null) {
                return null;
            }
            block0: for (ExecutableElement tMethod : ElementFilter.methodsIn(type.getEnclosedElements())) {
                if (!tMethod.getSimpleName().equals(method.getSimpleName()) || tMethod.getParameters().size() != nParams) continue;
                for (int i = 0; i < nParams; ++i) {
                    TypeMirror tParamType = this.typeUtils.erasure(tMethod.getParameters().get(i).asType());
                    if (!this.typeUtils.isSameType((TypeMirror)params.get(i), tParamType)) continue block0;
                }
                return tMethod;
            }
            return null;
        }

        private @Nullable TypeElement superclass(TypeElement type) {
            TypeMirror sup = type.getSuperclass();
            if (sup.getKind() == TypeKind.DECLARED) {
                return MoreElements.asType(this.typeUtils.asElement(sup));
            }
            return null;
        }

        private ImmutableList<TypeElement> superinterfaces(TypeElement type) {
            ImmutableList.Builder types = ImmutableList.builder();
            for (TypeMirror typeMirror : type.getInterfaces()) {
                types.add((Object)MoreElements.asType(this.typeUtils.asElement(typeMirror)));
            }
            return types.build();
        }

        private TypeElement asTypeElement(TypeMirror typeMirror) {
            DeclaredType declaredType = MoreTypes.asDeclared(typeMirror);
            Element element = declaredType.asElement();
            return MoreElements.asType(element);
        }

        private class TypeSubstVisitor
        extends SimpleTypeVisitor8<TypeMirror, Void> {
            private final Map<TypeParameterElement, TypeMirror> typeBindings = Maps.newLinkedHashMap();

            private TypeSubstVisitor() {
            }

            @Nullable ImmutableList<TypeMirror> erasedParameterTypes(ExecutableElement method, TypeElement in) {
                if (method.getEnclosingElement().equals(in)) {
                    ImmutableList.Builder params = ImmutableList.builder();
                    for (VariableElement variableElement : method.getParameters()) {
                        params.add((Object)ExplicitOverrides.this.typeUtils.erasure((TypeMirror)this.visit(variableElement.asType())));
                    }
                    return params.build();
                }
                ArrayList supers = Lists.newArrayList();
                if (in.getSuperclass().getKind() == TypeKind.DECLARED) {
                    supers.add(in.getSuperclass());
                }
                supers.addAll(in.getInterfaces());
                for (TypeMirror typeMirror : supers) {
                    DeclaredType declared = MoreTypes.asDeclared(typeMirror);
                    TypeElement element = MoreElements.asType(declared.asElement());
                    List<TypeMirror> actuals = declared.getTypeArguments();
                    List<? extends TypeParameterElement> formals = element.getTypeParameters();
                    if (actuals.isEmpty()) {
                        actuals = formals.stream().map(t -> t.getBounds().get(0)).collect(Collectors.toList());
                    }
                    Verify.verify((actuals.size() == formals.size() ? 1 : 0) != 0);
                    for (int i = 0; i < actuals.size(); ++i) {
                        this.typeBindings.put(formals.get(i), actuals.get(i));
                    }
                    ImmutableList<TypeMirror> params = this.erasedParameterTypes(method, element);
                    if (params == null) continue;
                    return params;
                }
                return null;
            }

            @Override
            protected TypeMirror defaultAction(TypeMirror e, Void p) {
                return e;
            }

            @Override
            public TypeMirror visitTypeVariable(TypeVariable t, Void p) {
                TypeParameterElement e;
                Element element = ExplicitOverrides.this.typeUtils.asElement(t);
                if (element instanceof TypeParameterElement && this.typeBindings.containsKey(e = (TypeParameterElement)element)) {
                    return (TypeMirror)this.visit(this.typeBindings.get(e));
                }
                return (TypeMirror)this.visit(ExplicitOverrides.this.typeUtils.erasure(t.getUpperBound()));
            }

            @Override
            public TypeMirror visitDeclared(DeclaredType t, Void p) {
                if (t.getTypeArguments().isEmpty()) {
                    return t;
                }
                ArrayList newArgs = Lists.newArrayList();
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    newArgs.add((TypeMirror)this.visit(typeMirror));
                }
                return ExplicitOverrides.this.typeUtils.getDeclaredType(ExplicitOverrides.this.asTypeElement(t), newArgs.toArray(new TypeMirror[0]));
            }

            @Override
            public TypeMirror visitArray(ArrayType t, Void p) {
                return ExplicitOverrides.this.typeUtils.getArrayType((TypeMirror)this.visit(t.getComponentType()));
            }
        }
    }

    static class NativeOverrides
    extends Overrides {
        private final Elements elementUtils;

        NativeOverrides(Elements elementUtils) {
            this.elementUtils = elementUtils;
        }

        @Override
        boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement in) {
            return this.elementUtils.overrides(overrider, overridden, in);
        }
    }
}

