/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.providers.xmemcached;

import com.google.code.ssm.providers.AbstractMemcacheClientWrapper;
import com.google.code.ssm.providers.CacheException;
import com.google.code.ssm.providers.CacheTranscoder;
import com.google.code.ssm.providers.CachedObject;
import com.google.code.ssm.providers.CachedObjectImpl;
import com.google.code.ssm.providers.xmemcached.TranscoderAdapter;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemcacheClientWrapper
extends AbstractMemcacheClientWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemcacheClientWrapper.class);
    private final Map<CacheTranscoder, Object> adapters = new HashMap<CacheTranscoder, Object>();
    private final MemcachedClient memcachedClient;

    MemcacheClientWrapper(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    public boolean add(String key, int exp, Object value) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.add(key, exp, value);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
    }

    public <T> boolean add(String key, int exp, T value, CacheTranscoder transcoder) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.add(key, exp, value, this.getTranscoder(transcoder));
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
    }

    public long decr(String key, int by) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.decr(key, (long)by);
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public long decr(String key, int by, long def) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.decr(key, (long)by, def);
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public boolean delete(String key) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.delete(key);
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public void flush() throws TimeoutException, CacheException {
        try {
            this.memcachedClient.flushAll();
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public Object get(String key) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.get(key);
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public <T> T get(String key, CacheTranscoder transcoder) throws TimeoutException, CacheException {
        try {
            return (T)this.memcachedClient.get(key, this.getTranscoder(transcoder));
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public <T> T get(String key, CacheTranscoder transcoder, long timeout) throws TimeoutException, CacheException {
        try {
            return (T)this.memcachedClient.get(key, timeout, this.getTranscoder(transcoder));
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public Collection<SocketAddress> getAvailableServers() {
        ArrayList<SocketAddress> servers = new ArrayList<SocketAddress>();
        Collection inetSocketAddresses = this.memcachedClient.getAvailableServers();
        if (inetSocketAddresses != null && inetSocketAddresses.size() > 0) {
            servers.addAll(inetSocketAddresses);
        }
        return servers;
    }

    public Map<String, Object> getBulk(Collection<String> keys) throws TimeoutException, CacheException {
        Map result = null;
        try {
            result = this.memcachedClient.get(keys);
            return result == null ? Collections.emptyMap() : result;
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public <T> Map<String, T> getBulk(Collection<String> keys, CacheTranscoder transcoder) throws TimeoutException, CacheException {
        Map result = null;
        try {
            result = this.memcachedClient.get(keys, this.getTranscoder(transcoder));
            return result == null ? Collections.emptyMap() : result;
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public long incr(String key, int by) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.incr(key, (long)by);
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public long incr(String key, int by, long def) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.incr(key, (long)by, def);
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public long incr(String key, int by, long def, int expiration) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.incr(key, (long)by, def, this.memcachedClient.getOpTimeout(), expiration);
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public boolean set(String key, int exp, Object value) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.set(key, exp, value);
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public <T> boolean set(String key, int exp, T value, CacheTranscoder transcoder) throws TimeoutException, CacheException {
        try {
            return this.memcachedClient.set(key, exp, value, this.getTranscoder(transcoder));
        }
        catch (InterruptedException e) {
            throw new CacheException((Exception)e);
        }
        catch (MemcachedException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public void shutdown() {
        try {
            this.memcachedClient.shutdown();
        }
        catch (IOException e) {
            LOGGER.error("An error occurred when closing memcache", (Throwable)e);
        }
    }

    public CacheTranscoder getTranscoder() {
        return new TranscoderWrapper((Transcoder<Object>)this.memcachedClient.getTranscoder());
    }

    private <T> Transcoder<T> getTranscoder(CacheTranscoder transcoder) {
        Transcoder transcoderAdapter = (Transcoder)this.adapters.get(transcoder);
        if (transcoderAdapter == null) {
            transcoderAdapter = new TranscoderAdapter(transcoder);
            this.adapters.put(transcoder, transcoderAdapter);
        }
        return transcoderAdapter;
    }

    private static class TranscoderWrapper
    implements CacheTranscoder {
        private final Transcoder<Object> transcoder;

        public TranscoderWrapper(Transcoder<Object> transcoder) {
            this.transcoder = transcoder;
        }

        public Object decode(CachedObject data) {
            return this.transcoder.decode(new CachedData(data.getFlags(), data.getData()));
        }

        public CachedObject encode(Object o) {
            CachedData cachedData = this.transcoder.encode(o);
            return new CachedObjectImpl(cachedData.getFlag(), cachedData.getData());
        }
    }
}

