/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.Replacement;
import com.google.code.maven_replacer_plugin.Replacer;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TokenReplacer
implements Replacer {
    public String replace(String content, Replacement replacement, boolean regex, int regexFlags) {
        if (regex) {
            return this.replaceRegex(content, replacement.getToken(), replacement.getValue(), regexFlags);
        }
        return this.replaceNonRegex(content, replacement.getToken(), replacement.getValue());
    }

    private String replaceRegex(String content, String token, String value, int flags) {
        Pattern compiledPattern = flags == -1 ? Pattern.compile(token) : Pattern.compile(token, flags);
        return compiledPattern.matcher(content).replaceAll(StringUtils.defaultString((String)value));
    }

    private String replaceNonRegex(String content, String token, String value) {
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        return content.replace(token, StringUtils.defaultString((String)value));
    }
}

