/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class BuildImageStep
implements Callable<Image> {
    private static final String DESCRIPTION = "Building container configuration";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final Image baseImage;
    private final List<PreparedLayer> baseImageLayers;
    private final List<PreparedLayer> applicationLayers;

    @VisibleForTesting
    static String truncateLongClasspath(ImmutableList<String> imageEntrypoint) {
        ArrayList<String> truncated = new ArrayList<String>();
        UnmodifiableIterator iterator = imageEntrypoint.iterator();
        while (iterator.hasNext()) {
            String element = (String)iterator.next();
            truncated.add(element);
            if (!element.equals("-cp") && !element.equals("-classpath")) continue;
            String classpath = (String)iterator.next();
            if (classpath.length() > 200) {
                truncated.add(classpath.substring(0, 200) + "<... classpath truncated ...>");
                continue;
            }
            truncated.add(classpath);
        }
        return ((Object)truncated).toString();
    }

    BuildImageStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Image baseImage, List<PreparedLayer> baseImageLayers, List<PreparedLayer> applicationLayers) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.baseImage = baseImage;
        this.baseImageLayers = baseImageLayers;
        this.applicationLayers = applicationLayers;
    }

    @Override
    public Image call() throws LayerPropertyNotFoundException {
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("building image format", 1L);){
            TimerEventDispatcher ignored2 = new TimerEventDispatcher(this.buildContext.getEventHandlers(), DESCRIPTION);
            try {
                Image.Builder imageBuilder = Image.builder(this.buildContext.getTargetFormat());
                this.baseImageLayers.forEach(imageBuilder::addLayer);
                int nonEmptyLayerCount = 0;
                for (HistoryEntry historyObject : this.baseImage.getHistory()) {
                    imageBuilder.addHistory(historyObject);
                    if (historyObject.hasCorrespondingLayer()) continue;
                    ++nonEmptyLayerCount;
                }
                imageBuilder.setArchitecture(this.baseImage.getArchitecture()).setOs(this.baseImage.getOs()).addEnvironment((Map<String, String>)this.baseImage.getEnvironment()).addLabels((Map<String, String>)this.baseImage.getLabels()).setHealthCheck(this.baseImage.getHealthCheck()).addExposedPorts((Set<Port>)this.baseImage.getExposedPorts()).addVolumes((Set<AbsoluteUnixPath>)this.baseImage.getVolumes()).setUser(this.baseImage.getUser()).setWorkingDirectory(this.baseImage.getWorkingDirectory());
                ContainerConfiguration containerConfiguration = this.buildContext.getContainerConfiguration();
                Instant layerCreationTime = containerConfiguration.getCreationTime();
                for (int count = 0; count < this.baseImageLayers.size() - nonEmptyLayerCount; ++count) {
                    imageBuilder.addHistory(HistoryEntry.builder().setCreationTimestamp(layerCreationTime).setComment("auto-generated by Jib").build());
                }
                for (PreparedLayer applicationLayer : this.applicationLayers) {
                    imageBuilder.addLayer(applicationLayer).addHistory(HistoryEntry.builder().setCreationTimestamp(layerCreationTime).setAuthor("Jib").setCreatedBy(this.buildContext.getToolName() + ":" + this.buildContext.getToolVersion()).setComment(applicationLayer.getName()).build());
                }
                imageBuilder.addEnvironment((Map<String, String>)containerConfiguration.getEnvironmentMap()).setCreated(containerConfiguration.getCreationTime()).setEntrypoint((List<String>)this.computeEntrypoint(this.baseImage, containerConfiguration)).setProgramArguments((List<String>)this.computeProgramArguments(this.baseImage, containerConfiguration)).addExposedPorts((Set<Port>)containerConfiguration.getExposedPorts()).addVolumes((Set<AbsoluteUnixPath>)containerConfiguration.getVolumes()).addLabels((Map<String, String>)containerConfiguration.getLabels());
                if (containerConfiguration.getUser() != null) {
                    imageBuilder.setUser(containerConfiguration.getUser());
                }
                if (containerConfiguration.getWorkingDirectory() != null) {
                    imageBuilder.setWorkingDirectory(containerConfiguration.getWorkingDirectory().toString());
                }
                Image image = imageBuilder.build();
                ignored2.close();
                return image;
            }
            catch (Throwable throwable) {
                try {
                    ignored2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Nullable
    private ImmutableList<String> computeEntrypoint(Image baseImage, ContainerConfiguration containerConfiguration) {
        ImmutableList<String> entrypointToUse;
        boolean shouldInherit = baseImage.getEntrypoint() != null && containerConfiguration.getEntrypoint() == null;
        ImmutableList<String> immutableList = entrypointToUse = shouldInherit ? baseImage.getEntrypoint() : containerConfiguration.getEntrypoint();
        if (entrypointToUse != null) {
            this.buildContext.getEventHandlers().dispatch(LogEvent.lifecycle(""));
            if (shouldInherit) {
                String message = "Container entrypoint set to " + entrypointToUse + " (inherited from base image)";
                this.buildContext.getEventHandlers().dispatch(LogEvent.lifecycle(message));
            } else {
                String message = "Container entrypoint set to " + BuildImageStep.truncateLongClasspath(entrypointToUse);
                this.buildContext.getEventHandlers().dispatch(LogEvent.lifecycle(message));
            }
        }
        return entrypointToUse;
    }

    @Nullable
    private ImmutableList<String> computeProgramArguments(Image baseImage, ContainerConfiguration containerConfiguration) {
        ImmutableList<String> programArgumentsToUse;
        boolean shouldInherit = baseImage.getProgramArguments() != null && containerConfiguration.getEntrypoint() == null && containerConfiguration.getProgramArguments() == null;
        ImmutableList<String> immutableList = programArgumentsToUse = shouldInherit ? baseImage.getProgramArguments() : containerConfiguration.getProgramArguments();
        if (programArgumentsToUse != null) {
            String logSuffix = shouldInherit ? " (inherited from base image)" : "";
            String message = "Container program arguments set to " + programArgumentsToUse + logSuffix;
            this.buildContext.getEventHandlers().dispatch(LogEvent.lifecycle(message));
        }
        return programArgumentsToUse;
    }
}

