/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

class MavenSettingsProxyProvider {
    private static final ImmutableList<String> PROXY_PROPERTIES = ImmutableList.of((Object)"proxyHost", (Object)"proxyPort", (Object)"proxyUser", (Object)"proxyPassword");

    private MavenSettingsProxyProvider() {
    }

    static void activateHttpAndHttpsProxies(Settings settings, SettingsDecrypter decrypter) throws MojoExecutionException {
        ArrayList proxies = new ArrayList(2);
        for (String protocol : ImmutableList.of((Object)"http", (Object)"https")) {
            if (MavenSettingsProxyProvider.areProxyPropertiesSet(protocol)) continue;
            settings.getProxies().stream().filter(Proxy::isActive).filter(proxy -> protocol.equals(proxy.getProtocol())).findFirst().ifPresent(proxies::add);
        }
        if (proxies.isEmpty()) {
            return;
        }
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest().setProxies(proxies);
        SettingsDecryptionResult result = decrypter.decrypt((SettingsDecryptionRequest)request);
        for (SettingsProblem problem : result.getProblems()) {
            if (problem.getSeverity() != SettingsProblem.Severity.ERROR && problem.getSeverity() != SettingsProblem.Severity.FATAL) continue;
            throw new MojoExecutionException("Unable to decrypt proxy info from settings.xml: " + problem);
        }
        result.getProxies().forEach(MavenSettingsProxyProvider::setProxyProperties);
    }

    @VisibleForTesting
    static void setProxyProperties(Proxy proxy) {
        String protocol = proxy.getProtocol();
        MavenSettingsProxyProvider.setPropertySafe(protocol + ".proxyHost", proxy.getHost());
        MavenSettingsProxyProvider.setPropertySafe(protocol + ".proxyPort", String.valueOf(proxy.getPort()));
        MavenSettingsProxyProvider.setPropertySafe(protocol + ".proxyUser", proxy.getUsername());
        MavenSettingsProxyProvider.setPropertySafe(protocol + ".proxyPassword", proxy.getPassword());
        MavenSettingsProxyProvider.setPropertySafe("http.nonProxyHosts", proxy.getNonProxyHosts());
    }

    private static void setPropertySafe(String property, @Nullable String value) {
        if (value != null) {
            System.setProperty(property, value);
        }
    }

    @VisibleForTesting
    static boolean areProxyPropertiesSet(String protocol) {
        return PROXY_PROPERTIES.stream().anyMatch(property -> System.getProperty(protocol + "." + property) != null);
    }
}

