/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.docker.json.DockerManifestEntryTemplate;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.image.json.OciIndexTemplate;
import com.google.cloud.tools.jib.image.json.OciManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;

public class ImageTarball {
    private static final String CONTAINER_CONFIGURATION_JSON_FILE_NAME = "config.json";
    private static final String MANIFEST_JSON_FILE_NAME = "manifest.json";
    private static final String LAYER_FILE_EXTENSION = ".tar.gz";
    private static final Instant TAR_ENTRY_MODIFICATION_TIME = Instant.EPOCH;
    private final Image image;
    private final ImageReference imageReference;
    private final ImmutableSet<String> allTargetImageTags;

    public ImageTarball(Image image, ImageReference imageReference, ImmutableSet<String> allTargetImageTags) {
        this.image = image;
        this.imageReference = imageReference;
        this.allTargetImageTags = allTargetImageTags;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.image.getImageFormat() == OciManifestTemplate.class) {
            this.ociWriteTo(out);
        } else {
            this.dockerWriteTo(out);
        }
    }

    private void ociWriteTo(OutputStream out) throws IOException {
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        OciManifestTemplate manifest = new OciManifestTemplate();
        for (Layer layer : this.image.getLayers()) {
            DescriptorDigest digest = layer.getBlobDescriptor().getDigest();
            long size = layer.getBlobDescriptor().getSize();
            tarStreamBuilder.addBlobEntry(layer.getBlob(), size, "blobs/sha256/" + digest.getHash(), TAR_ENTRY_MODIFICATION_TIME);
            manifest.addLayer(size, digest);
        }
        JsonTemplate containerConfiguration = new ImageToJsonTranslator(this.image).getContainerConfiguration();
        BlobDescriptor configDescriptor = Digests.computeDigest(containerConfiguration);
        manifest.setContainerConfiguration(configDescriptor.getSize(), configDescriptor.getDigest());
        tarStreamBuilder.addByteEntry(JsonTemplateMapper.toByteArray(containerConfiguration), "blobs/sha256/" + configDescriptor.getDigest().getHash(), TAR_ENTRY_MODIFICATION_TIME);
        BlobDescriptor manifestDescriptor = Digests.computeDigest(manifest);
        tarStreamBuilder.addByteEntry(JsonTemplateMapper.toByteArray(manifest), "blobs/sha256/" + manifestDescriptor.getDigest().getHash(), TAR_ENTRY_MODIFICATION_TIME);
        tarStreamBuilder.addByteEntry("{\"imageLayoutVersion\": \"1.0.0\"}".getBytes(StandardCharsets.UTF_8), "oci-layout", TAR_ENTRY_MODIFICATION_TIME);
        OciIndexTemplate index = new OciIndexTemplate();
        index.addManifest(manifestDescriptor, this.imageReference.toStringWithQualifier());
        tarStreamBuilder.addByteEntry(JsonTemplateMapper.toByteArray(index), "index.json", TAR_ENTRY_MODIFICATION_TIME);
        tarStreamBuilder.writeAsTarArchiveTo(out);
    }

    private void dockerWriteTo(OutputStream out) throws IOException {
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        DockerManifestEntryTemplate manifestTemplate = new DockerManifestEntryTemplate();
        for (Layer layer : this.image.getLayers()) {
            String layerName = layer.getBlobDescriptor().getDigest().getHash() + LAYER_FILE_EXTENSION;
            tarStreamBuilder.addBlobEntry(layer.getBlob(), layer.getBlobDescriptor().getSize(), layerName, TAR_ENTRY_MODIFICATION_TIME);
            manifestTemplate.addLayerFile(layerName);
        }
        JsonTemplate containerConfiguration = new ImageToJsonTranslator(this.image).getContainerConfiguration();
        tarStreamBuilder.addByteEntry(JsonTemplateMapper.toByteArray(containerConfiguration), CONTAINER_CONFIGURATION_JSON_FILE_NAME, TAR_ENTRY_MODIFICATION_TIME);
        for (String tag : this.allTargetImageTags) {
            manifestTemplate.addRepoTag(this.imageReference.withQualifier(tag).toStringWithQualifier());
        }
        tarStreamBuilder.addByteEntry(JsonTemplateMapper.toByteArray(Collections.singletonList(manifestTemplate)), MANIFEST_JSON_FILE_NAME, TAR_ENTRY_MODIFICATION_TIME);
        tarStreamBuilder.writeAsTarArchiveTo(out);
    }

    public long getTotalLayerSize() {
        long size = 0L;
        for (Layer layer : this.image.getLayers()) {
            size += layer.getBlobDescriptor().getSize();
        }
        return size;
    }
}

