/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerDescription;
import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.ContainerBuildPlan;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.LayerObject;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class JibContainerBuilder {
    private final ContainerBuildPlan.Builder containerBuildPlanBuilder = ContainerBuildPlan.builder();
    private final ContainerConfiguration.Builder containerConfigurationBuilder = ContainerConfiguration.builder();
    private final BuildContext.Builder buildContextBuilder;
    private ImageConfiguration baseImageConfiguration;
    private List<FileEntriesLayer> layerConfigurations = new ArrayList<FileEntriesLayer>();

    private static String capitalizeFirstLetter(String string) {
        if (string.isEmpty()) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    JibContainerBuilder(RegistryImage baseImage) {
        this(ImageConfiguration.builder(baseImage.getImageReference()).setCredentialRetrievers(baseImage.getCredentialRetrievers()).build(), BuildContext.builder());
    }

    JibContainerBuilder(DockerDaemonImage baseImage) {
        this(ImageConfiguration.builder(baseImage.getImageReference()).setDockerClient(new DockerClient(baseImage.getDockerExecutable(), baseImage.getDockerEnvironment())).build(), BuildContext.builder());
    }

    JibContainerBuilder(TarImage baseImage) {
        this(ImageConfiguration.builder(baseImage.getImageReference().orElse(ImageReference.scratch())).setTarPath(baseImage.getPath()).build(), BuildContext.builder());
    }

    @VisibleForTesting
    JibContainerBuilder(ImageConfiguration imageConfiguration, BuildContext.Builder buildContextBuilder) {
        this.buildContextBuilder = buildContextBuilder.setBaseImageConfiguration(imageConfiguration);
        this.baseImageConfiguration = imageConfiguration;
        this.containerBuildPlanBuilder.setBaseImage(imageConfiguration.getImage().toString());
    }

    public JibContainerBuilder addLayer(List<Path> files, AbsoluteUnixPath pathInContainer) throws IOException {
        FileEntriesLayer.Builder layerConfigurationBuilder = FileEntriesLayer.builder();
        for (Path file : files) {
            layerConfigurationBuilder.addEntryRecursive(file, pathInContainer.resolve(file.getFileName()));
        }
        return this.addFileEntriesLayer(layerConfigurationBuilder.build());
    }

    public JibContainerBuilder addLayer(List<Path> files, String pathInContainer) throws IOException {
        return this.addLayer(files, AbsoluteUnixPath.get((String)pathInContainer));
    }

    @Deprecated
    public JibContainerBuilder addLayer(LayerConfiguration layerConfiguration) {
        return this.addFileEntriesLayer(layerConfiguration.toFileEntriesLayer());
    }

    public JibContainerBuilder addFileEntriesLayer(FileEntriesLayer layer) {
        this.containerBuildPlanBuilder.addLayer((LayerObject)layer);
        this.layerConfigurations.add(layer);
        return this;
    }

    @Deprecated
    public JibContainerBuilder setLayers(List<LayerConfiguration> layerConfigurations) {
        return this.setFileEntriesLayers(layerConfigurations.stream().map(LayerConfiguration::toFileEntriesLayer).collect(Collectors.toList()));
    }

    public JibContainerBuilder setFileEntriesLayers(List<FileEntriesLayer> layers) {
        this.containerBuildPlanBuilder.setLayers(layers);
        this.layerConfigurations = new ArrayList<FileEntriesLayer>(layers);
        return this;
    }

    @Deprecated
    public JibContainerBuilder setLayers(LayerConfiguration ... layerConfigurations) {
        return this.setLayers(Arrays.asList(layerConfigurations));
    }

    public JibContainerBuilder setFileEntriesLayers(FileEntriesLayer ... layers) {
        return this.setFileEntriesLayers(Arrays.asList(layers));
    }

    public JibContainerBuilder setEntrypoint(@Nullable List<String> entrypoint) {
        this.containerBuildPlanBuilder.setEntrypoint(entrypoint);
        this.containerConfigurationBuilder.setEntrypoint(entrypoint);
        return this;
    }

    public JibContainerBuilder setEntrypoint(String ... entrypoint) {
        return this.setEntrypoint(Arrays.asList(entrypoint));
    }

    public JibContainerBuilder setProgramArguments(@Nullable List<String> programArguments) {
        this.containerBuildPlanBuilder.setCmd(programArguments);
        this.containerConfigurationBuilder.setProgramArguments(programArguments);
        return this;
    }

    public JibContainerBuilder setProgramArguments(String ... programArguments) {
        return this.setProgramArguments(Arrays.asList(programArguments));
    }

    public JibContainerBuilder setEnvironment(Map<String, String> environmentMap) {
        this.containerBuildPlanBuilder.setEnvironment(environmentMap);
        this.containerConfigurationBuilder.setEnvironment(environmentMap);
        return this;
    }

    public JibContainerBuilder addEnvironmentVariable(String name, String value) {
        this.containerBuildPlanBuilder.addEnvironmentVariable(name, value);
        this.containerConfigurationBuilder.addEnvironment(name, value);
        return this;
    }

    public JibContainerBuilder setVolumes(Set<AbsoluteUnixPath> volumes) {
        this.containerBuildPlanBuilder.setVolumes(volumes);
        this.containerConfigurationBuilder.setVolumes(volumes);
        return this;
    }

    public JibContainerBuilder setVolumes(AbsoluteUnixPath ... volumes) {
        return this.setVolumes(new HashSet<AbsoluteUnixPath>(Arrays.asList(volumes)));
    }

    public JibContainerBuilder addVolume(AbsoluteUnixPath volume) {
        this.containerBuildPlanBuilder.addVolume(volume);
        this.containerConfigurationBuilder.addVolume(volume);
        return this;
    }

    public JibContainerBuilder setExposedPorts(Set<Port> ports) {
        this.containerBuildPlanBuilder.setExposedPorts(ports);
        this.containerConfigurationBuilder.setExposedPorts(ports);
        return this;
    }

    public JibContainerBuilder setExposedPorts(Port ... ports) {
        return this.setExposedPorts(new HashSet<Port>(Arrays.asList(ports)));
    }

    public JibContainerBuilder addExposedPort(Port port) {
        this.containerBuildPlanBuilder.addExposedPort(port);
        this.containerConfigurationBuilder.addExposedPort(port);
        return this;
    }

    public JibContainerBuilder setLabels(Map<String, String> labelMap) {
        this.containerBuildPlanBuilder.setLabels(labelMap);
        this.containerConfigurationBuilder.setLabels(labelMap);
        return this;
    }

    public JibContainerBuilder addLabel(String key, String value) {
        this.containerBuildPlanBuilder.addLabel(key, value);
        this.containerConfigurationBuilder.addLabel(key, value);
        return this;
    }

    public JibContainerBuilder setFormat(ImageFormat imageFormat) {
        this.containerBuildPlanBuilder.setFormat(imageFormat);
        this.buildContextBuilder.setTargetFormat(imageFormat);
        return this;
    }

    public JibContainerBuilder setCreationTime(Instant creationTime) {
        this.containerBuildPlanBuilder.setCreationTime(creationTime);
        this.containerConfigurationBuilder.setCreationTime(creationTime);
        return this;
    }

    public JibContainerBuilder setPlatforms(Set<Platform> platforms) {
        this.containerBuildPlanBuilder.setPlatforms(platforms);
        this.containerConfigurationBuilder.setPlatforms(platforms);
        return this;
    }

    public JibContainerBuilder addPlatform(String architecture, String os) {
        this.containerBuildPlanBuilder.addPlatform(architecture, os);
        this.containerConfigurationBuilder.addPlatform(architecture, os);
        return this;
    }

    public JibContainerBuilder setUser(@Nullable String user) {
        this.containerBuildPlanBuilder.setUser(user);
        this.containerConfigurationBuilder.setUser(user);
        return this;
    }

    public JibContainerBuilder setWorkingDirectory(@Nullable AbsoluteUnixPath workingDirectory) {
        this.containerBuildPlanBuilder.setWorkingDirectory(workingDirectory);
        this.containerConfigurationBuilder.setWorkingDirectory(workingDirectory);
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public JibContainer containerize(Containerizer containerizer) throws InterruptedException, RegistryException, IOException, CacheDirectoryCreationException, ExecutionException {
        try {
            Throwable throwable = null;
            try (BuildContext buildContext = this.toBuildContext(containerizer);){
                JibContainer jibContainer;
                TimerEventDispatcher ignored = new TimerEventDispatcher(buildContext.getEventHandlers(), containerizer.getDescription());
                Throwable throwable2 = null;
                try {
                    if (buildContext.getContainerConfiguration().getPlatforms().size() != 1) {
                        throw new UnsupportedOperationException("multi-platform image building is not yet supported");
                    }
                    this.logSources(buildContext.getEventHandlers());
                    BuildResult buildResult = containerizer.run(buildContext);
                    jibContainer = JibContainer.from(buildContext, buildResult);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            JibContainerBuilder.$closeResource(throwable2, ignored);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                JibContainerBuilder.$closeResource(throwable2, ignored);
                return jibContainer;
            }
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof RegistryException) {
                throw (RegistryException)ex.getCause();
            }
            throw ex;
        }
    }

    @Deprecated
    public JibContainerDescription describeContainer() {
        return new JibContainerDescription(this.layerConfigurations);
    }

    public ContainerBuildPlan toContainerBuildPlan() {
        return this.containerBuildPlanBuilder.build();
    }

    public JibContainerBuilder applyContainerBuildPlan(ContainerBuildPlan buildPlan) throws InvalidImageReferenceException {
        this.containerBuildPlanBuilder.setBaseImage(buildPlan.getBaseImage()).setPlatforms(buildPlan.getPlatforms()).setCreationTime(buildPlan.getCreationTime()).setFormat(buildPlan.getFormat()).setEnvironment(buildPlan.getEnvironment()).setLabels(buildPlan.getLabels()).setVolumes(buildPlan.getVolumes()).setExposedPorts(buildPlan.getExposedPorts()).setUser(buildPlan.getUser()).setWorkingDirectory(buildPlan.getWorkingDirectory()).setEntrypoint(buildPlan.getEntrypoint()).setCmd(buildPlan.getCmd()).setLayers(buildPlan.getLayers());
        this.containerConfigurationBuilder.setPlatforms(buildPlan.getPlatforms()).setCreationTime(buildPlan.getCreationTime()).setEnvironment(buildPlan.getEnvironment()).setLabels(buildPlan.getLabels()).setVolumes(buildPlan.getVolumes()).setExposedPorts(buildPlan.getExposedPorts()).setUser(buildPlan.getUser()).setWorkingDirectory(buildPlan.getWorkingDirectory()).setEntrypoint(buildPlan.getEntrypoint()).setProgramArguments(buildPlan.getCmd());
        ImageConfiguration.Builder builder = ImageConfiguration.builder(ImageReference.parse(buildPlan.getBaseImage())).setCredentialRetrievers((List<CredentialRetriever>)this.baseImageConfiguration.getCredentialRetrievers());
        this.baseImageConfiguration.getDockerClient().ifPresent(builder::setDockerClient);
        this.baseImageConfiguration.getTarPath().ifPresent(builder::setTarPath);
        this.baseImageConfiguration = builder.build();
        Function<LayerObject, FileEntriesLayer> castToFileEntriesLayer = layer -> {
            Verify.verify((boolean)(layer instanceof FileEntriesLayer), (String)"layer types other than FileEntriesLayer not yet supported in build plan layers", (Object[])new Object[0]);
            return (FileEntriesLayer)layer;
        };
        this.layerConfigurations = buildPlan.getLayers().stream().map(castToFileEntriesLayer).collect(Collectors.toList());
        this.buildContextBuilder.setTargetFormat(buildPlan.getFormat()).setBaseImageConfiguration(this.baseImageConfiguration).setLayerConfigurations(this.layerConfigurations);
        return this;
    }

    @VisibleForTesting
    BuildContext toBuildContext(Containerizer containerizer) throws CacheDirectoryCreationException {
        return this.buildContextBuilder.setTargetImageConfiguration(containerizer.getImageConfiguration()).setAdditionalTargetImageTags(containerizer.getAdditionalTags()).setBaseImageLayersCacheDirectory(containerizer.getBaseImageLayersCacheDirectory()).setApplicationLayersCacheDirectory(containerizer.getApplicationLayersCacheDirectory()).setContainerConfiguration(this.containerConfigurationBuilder.build()).setLayerConfigurations(this.layerConfigurations).setAllowInsecureRegistries(containerizer.getAllowInsecureRegistries()).setOffline(containerizer.isOfflineMode()).setToolName(containerizer.getToolName()).setToolVersion(containerizer.getToolVersion()).setExecutorService(containerizer.getExecutorService().orElse(null)).setEventHandlers(containerizer.buildEventHandlers()).setAlwaysCacheBaseImage(containerizer.getAlwaysCacheBaseImage()).build();
    }

    private void logSources(EventHandlers eventHandlers) {
        eventHandlers.dispatch(LogEvent.info("Containerizing application with the following files:"));
        for (FileEntriesLayer layer : this.layerConfigurations) {
            if (layer.getEntries().isEmpty()) continue;
            eventHandlers.dispatch(LogEvent.info("\t" + JibContainerBuilder.capitalizeFirstLetter(layer.getName()) + ":"));
            for (FileEntry entry : layer.getEntries()) {
                eventHandlers.dispatch(LogEvent.info("\t\t" + entry.getSourceFile()));
            }
        }
    }
}

