/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.plugins.extension.ExtensionLogger;
import java.util.function.Consumer;

class MavenExtensionLogger
implements ExtensionLogger {
    private final Consumer<LogEvent> logger;

    MavenExtensionLogger(Consumer<LogEvent> logger) {
        this.logger = logger;
    }

    @Override
    public void log(ExtensionLogger.LogLevel logLevel, String message) {
        switch (logLevel) {
            case ERROR: {
                this.logger.accept(LogEvent.error(message));
                break;
            }
            case WARN: {
                this.logger.accept(LogEvent.warn(message));
                break;
            }
            case LIFECYCLE: {
                this.logger.accept(LogEvent.lifecycle(message));
                break;
            }
            case INFO: {
                this.logger.accept(LogEvent.info(message));
                break;
            }
            case DEBUG: {
                this.logger.accept(LogEvent.debug(message));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }
}

