/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ports {
    private static final Pattern portPattern = Pattern.compile("(\\d+)(?:-(\\d+))?(?:/(tcp|udp))?");

    public static ImmutableSet<Port> parse(List<String> ports) throws NumberFormatException {
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        for (String port : ports) {
            int min;
            Matcher matcher = portPattern.matcher(port);
            if (!matcher.matches()) {
                throw new NumberFormatException("Invalid port configuration: '" + port + "'. Make sure the port is a single number or a range of two numbers separated with a '-', with or without protocol specified (e.g. '<portNum>/tcp' or '<portNum>/udp').");
            }
            int max = min = Integer.parseInt(matcher.group(1));
            if (!Strings.isNullOrEmpty((String)matcher.group(2))) {
                max = Integer.parseInt(matcher.group(2));
            }
            String protocol = matcher.group(3);
            if (min > max) {
                throw new NumberFormatException("Invalid port range '" + port + "'; smaller number must come first.");
            }
            if (min < 1 || max > 65535) {
                throw new NumberFormatException("Port number '" + port + "' is out of usual range (1-65535).");
            }
            for (int portNumber = min; portNumber <= max; ++portNumber) {
                result.add((Object)Port.parseProtocol(portNumber, protocol));
            }
        }
        return result.build();
    }

    private Ports() {
    }
}

